/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.util.Preconditions;

public class LazyValue<T> {
    private T value;
    private Supplier<T> valueSupplier;

    public LazyValue(Supplier<T> supplier) {
        Preconditions.checkArgument(supplier != null, "supplier cannot be null");
        this.valueSupplier = () -> {
            LazyValue lazyValue = this;
            synchronized (lazyValue) {
                if (this.value == null) {
                    this.value = supplier.get();
                    this.valueSupplier = () -> this.value;
                }
                return this.value;
            }
        };
    }

    public LazyValue(T value) {
        this.value = value;
        this.valueSupplier = () -> value;
    }

    public T get() {
        return this.valueSupplier.get();
    }

    public boolean isComputed() {
        return this.value != null;
    }

    public void ifComputed(Consumer<T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public <R> R flatMap(Function<T, R> function) {
        return function.apply(this.get());
    }
}

