/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.config.spring.SpringRegistry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.config.builders.AbstractConfigurationBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringConfigurationBuilder
extends AbstractConfigurationBuilder {
    private ApplicationContext appContext;
    private ApplicationContext parentContext;

    public SpringConfigurationBuilder(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    public SpringConfigurationBuilder(ConfigurableApplicationContext appContext, ApplicationContext parentContext) {
        this.appContext = appContext;
        this.parentContext = parentContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doConfigure(MuleContext muleContext) throws Exception {
        SpringRegistry registry;
        if (this.parentContext != null) {
            if (!(this.appContext instanceof ConfigurableApplicationContext)) throw new ConfigurationException(I18nMessageFactory.createStaticMessage("Cannot set a parent context if the ApplicationContext does not implement ConfigurableApplicationContext"));
            registry = new SpringRegistry((ConfigurableApplicationContext)this.appContext, this.parentContext, muleContext);
        } else {
            registry = new SpringRegistry(this.appContext, muleContext);
        }
        muleContext.addRegistry(registry);
        if (!muleContext.getLifecycleManager().isPhaseComplete("initialise")) return;
        registry.initialise();
    }
}

