/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.factories;

import javax.transaction.TransactionManager;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.transaction.TransactionManagerFactory;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class TransactionManagerFactoryBean
implements FactoryBean<TransactionManager>,
MuleContextAware {
    @Autowired(required=false)
    private TransactionManagerFactory txManagerFactory;
    @Autowired(required=false)
    private TransactionManager customTxManager;
    private MuleContext muleContext;

    public TransactionManager getObject() throws Exception {
        if (this.muleContext.isDisposing()) {
            return null;
        }
        if (this.txManagerFactory != null) {
            try {
                return this.txManagerFactory.create(this.muleContext.getConfiguration());
            }
            catch (Exception e) {
                throw new MuleRuntimeException(CoreMessages.failedToCreate("transaction manager"), (Throwable)e);
            }
        }
        return this.customTxManager;
    }

    public Class<?> getObjectType() {
        return TransactionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setTxManagerFactory(TransactionManagerFactory txManagerFactory) {
        this.txManagerFactory = txManagerFactory;
    }

    public void setCustomTxManager(TransactionManager customTxManager) {
        this.customTxManager = customTxManager;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

