/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.parsers.generic;

import org.mule.runtime.config.spring.parsers.generic.AutoIdUtils;
import org.mule.runtime.config.spring.parsers.generic.ChildDefinitionParser;
import org.mule.runtime.core.api.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public class ChildEmbeddedDefinitionParser
extends ChildDefinitionParser {
    public ChildEmbeddedDefinitionParser(Class<?> clazz) {
        super("messageProcessor", clazz);
        this.addIgnored("ref");
    }

    @Override
    public BeanDefinitionBuilder createBeanDefinitionBuilder(Element element, Class<?> beanClass) {
        BeanDefinitionBuilder builder = super.createBeanDefinitionBuilder(element, beanClass);
        String global = element.getAttribute("ref");
        if (!StringUtils.isBlank(global)) {
            builder.addConstructorArgReference(global);
            builder.addDependsOn(global);
        }
        return builder;
    }

    @Override
    public String getPropertyName(Element e) {
        String parent = e.getParentNode().getLocalName().toLowerCase();
        if (e.getLocalName() != null && e.getLocalName().toLowerCase().equals("poll")) {
            return "messageSource";
        }
        if ("wire-tap".equals(parent) || "wire-tap-router".equals(parent)) {
            return "tap";
        }
        return super.getPropertyName(e);
    }

    @Override
    public String getBeanName(Element element) {
        if (null != element.getAttributeNode("ref")) {
            return AutoIdUtils.uniqueValue("ref:" + element.getAttribute("ref"));
        }
        return super.getBeanName(element);
    }
}

