/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedList;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.util.Preconditions;

public abstract class ServiceInvocationHandler
implements InvocationHandler {
    private final Service service;

    protected ServiceInvocationHandler(Service service) {
        Preconditions.checkArgument(service != null, "service cannot be null");
        this.service = service;
    }

    protected Method[] getServiceImplementationDeclaredMethods() {
        if (Proxy.isProxyClass(this.getService().getClass()) && Proxy.getInvocationHandler(this.getService()) instanceof ServiceInvocationHandler) {
            return ((ServiceInvocationHandler)Proxy.getInvocationHandler(this.getService())).getServiceImplementationDeclaredMethods();
        }
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Class<?> clazz = this.getService().getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        }
        return methods.toArray(new Method[methods.size()]);
    }

    protected Object doInvoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Proxy.isProxyClass(this.getService().getClass()) && Proxy.getInvocationHandler(this.getService()) instanceof ServiceInvocationHandler) {
            return ((ServiceInvocationHandler)Proxy.getInvocationHandler(this.getService())).invoke(this.getService(), method, args);
        }
        try {
            return method.invoke((Object)this.getService(), args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected Service getService() {
        return this.service;
    }
}

