/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.exception;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class RedeliveryExceeded
implements FlowConstructAware,
Initialisable,
ReactiveProcessor {
    private List<Processor> messageProcessors = new CopyOnWriteArrayList<Processor>();
    private MessageProcessorChain configuredMessageProcessors;
    private FlowConstruct flowConstruct;

    @Override
    public void initialise() throws InitialisationException {
        this.configuredMessageProcessors = MessageProcessors.newChain(this.messageProcessors);
    }

    public List<Processor> getMessageProcessors() {
        return Collections.unmodifiableList(this.messageProcessors);
    }

    public void setMessageProcessors(List<Processor> processors) {
        if (processors == null) {
            throw new IllegalArgumentException("List of targets = null");
        }
        this.messageProcessors.clear();
        this.messageProcessors.addAll(processors);
    }

    public Event process(Event event) throws MuleException {
        Event result = event;
        if (!this.messageProcessors.isEmpty()) {
            result = this.configuredMessageProcessors.process(event);
        }
        if (result != null) {
            result = this.removeErrorFromEvent(result);
        }
        return result;
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> eventPublisher) {
        if (!this.messageProcessors.isEmpty()) {
            return Flux.from(eventPublisher).transform((Function)this.configuredMessageProcessors);
        }
        return Flux.from(eventPublisher).map(event -> this.removeErrorFromEvent((Event)event));
    }

    private Event removeErrorFromEvent(Event result) {
        return Event.builder(result).error(null).message(InternalMessage.builder(result.getMessage()).exceptionPayload(null).build()).build();
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }
}

