/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.function.Supplier;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.streaming.AbstractStreamingBuffer;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.InputStreamBuffer;

public abstract class AbstractInputStreamBuffer
extends AbstractStreamingBuffer
implements InputStreamBuffer {
    protected final ByteBufferManager bufferManager;
    private final InputStream stream;
    private ReadableByteChannel streamChannel;
    private boolean streamFullyConsumed = false;
    protected LazyValue<ByteBuffer> buffer;

    public AbstractInputStreamBuffer(InputStream stream, ByteBufferManager bufferManager, int bufferSize) {
        this(stream, AbstractInputStreamBuffer.openStreamChannel(stream), bufferManager, bufferSize);
    }

    public AbstractInputStreamBuffer(InputStream stream, ReadableByteChannel streamChannel, ByteBufferManager bufferManager, int bufferSize) {
        this.stream = stream;
        this.streamChannel = streamChannel;
        this.bufferManager = bufferManager;
        this.buffer = new LazyValue<Supplier<ByteBuffer>>(() -> bufferManager.allocate(bufferSize));
    }

    protected static ReadableByteChannel openStreamChannel(InputStream stream) {
        return stream != null ? Channels.newChannel(stream) : null;
    }

    public abstract int consumeForwardData() throws IOException;

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.withWriteLock(() -> {
                try {
                    this.doClose();
                    Object var1_1 = null;
                    return var1_1;
                }
                finally {
                    if (this.streamChannel != null) {
                        this.closeSafely(this.streamChannel::close);
                    }
                    if (this.stream != null) {
                        this.closeSafely(this.stream::close);
                    }
                    this.buffer.ifComputed(this::deallocate);
                }
            });
        }
    }

    public abstract void doClose();

    @Override
    public final ByteBuffer get(long position, int length) {
        Preconditions.checkState(!this.closed.get(), "Buffer is closed");
        return this.doGet(position, length);
    }

    protected abstract ByteBuffer doGet(long var1, int var3);

    protected void consume(ByteBuffer data) {
        int read = data.remaining();
        if (read > 0) {
            this.buffer.get().put(data);
        }
    }

    public ByteBuffer getBuffer() {
        return this.buffer.get();
    }

    protected int consumeStream(ByteBuffer buffer) throws IOException {
        int result;
        try {
            result = this.streamChannel.read(buffer);
        }
        catch (ClosedChannelException e) {
            result = -1;
        }
        return result;
    }

    protected void deallocate(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            this.closeSafely(() -> this.bufferManager.deallocate(byteBuffer));
        }
    }

    protected boolean isStreamFullyConsumed() {
        return this.streamFullyConsumed;
    }

    protected void streamFullyConsumed() {
        this.streamFullyConsumed = true;
    }

    protected final ByteBuffer copy(long position, int length) {
        return this.canDoSoftCopy() ? this.softCopy(position, length) : this.hardCopy(position, length);
    }

    protected abstract boolean canDoSoftCopy();

    private ByteBuffer softCopy(long position, int length) {
        int offset = Math.toIntExact(position);
        ByteBuffer b = this.buffer.get();
        return ByteBuffer.wrap(b.array(), offset, Math.min(length, b.limit() - offset)).slice();
    }

    private ByteBuffer hardCopy(long position, int length) {
        int offset = Math.toIntExact(position);
        ByteBuffer bf = this.buffer.get();
        length = Math.min(length, bf.limit() - offset);
        byte[] b = new byte[length];
        System.arraycopy(bf.array(), offset, b, 0, length);
        return ByteBuffer.wrap(b);
    }
}

