/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer;

import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transformer.DataTypeConversionResolver;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicDataTypeConversionResolver
implements DataTypeConversionResolver {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDataTypeConversionResolver.class);
    private final MuleContext muleContext;

    @Inject
    public DynamicDataTypeConversionResolver(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public Transformer resolve(DataType sourceType, List<DataType> targetDataTypes) {
        Transformer transformer = null;
        for (DataType targetDataType : targetDataTypes) {
            try {
                transformer = this.muleContext.getRegistry().lookupTransformer(sourceType, targetDataType);
                if (transformer == null) continue;
                break;
            }
            catch (TransformerException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Unable to find an implicit conversion from " + sourceType + " to " + targetDataType);
            }
        }
        return transformer;
    }
}

