/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.TransactionAwareWorkQueueProcessingStrategyFactory;
import org.mule.runtime.core.transaction.TransactionCoordination;

public class ProcessingStrategyUtils {
    public static String DEFAULT_PROCESSING_STRATEGY = "default";
    public static String SYNC_PROCESSING_STRATEGY = "synchronous";

    public static ProcessingStrategyFactory parseProcessingStrategy(String processingStrategy) {
        if (DEFAULT_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new TransactionAwareWorkQueueProcessingStrategyFactory();
        }
        if (SYNC_PROCESSING_STRATEGY.equals(processingStrategy)) {
            return new BlockingProcessingStrategyFactory();
        }
        return null;
    }

    public static boolean isSynchronousProcessing(FlowConstruct flowConstruct) {
        return flowConstruct instanceof Pipeline && ((Pipeline)flowConstruct).isSynchronous() || TransactionCoordination.isTransactionActive();
    }
}

