/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderManager;
import org.mule.runtime.module.artifact.classloader.ClassLoaderRepository;

public class DefaultClassLoaderManager
implements ArtifactClassLoaderManager,
ClassLoaderRepository {
    private final Map<String, ArtifactClassLoader> artifactClassLoaders = new ConcurrentHashMap<String, ArtifactClassLoader>();

    @Override
    public void register(ArtifactClassLoader artifactClassLoader) {
        Preconditions.checkArgument(artifactClassLoader != null, "artifactClassLoader cannot be null");
        this.artifactClassLoaders.put(artifactClassLoader.getArtifactId(), artifactClassLoader);
    }

    @Override
    public ArtifactClassLoader unregister(String classLoaderId) {
        this.checkClassLoaderId(classLoaderId);
        return this.artifactClassLoaders.remove(classLoaderId);
    }

    @Override
    public Optional<ClassLoader> find(String classLoaderId) {
        this.checkClassLoaderId(classLoaderId);
        ArtifactClassLoader artifactClassLoader = this.artifactClassLoaders.get(classLoaderId);
        return Optional.of(artifactClassLoader.getClassLoader());
    }

    @Override
    public Optional<String> getId(ClassLoader classLoader) {
        return this.artifactClassLoaders.values().stream().filter(artifactClassLoader -> artifactClassLoader.getClassLoader().equals(classLoader)).findFirst().map(ArtifactClassLoader::getArtifactId);
    }

    private void checkClassLoaderId(String classLoaderId) {
        Preconditions.checkArgument(!StringUtils.isEmpty(classLoaderId), "artifactId cannot be empty");
    }
}

