/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.transaction;

import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.connection.ConnectionHandlerAdapter;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.module.extension.internal.runtime.transaction.ExtensionTransactionalResource;

public final class TransactionalConnectionHandler<T extends TransactionalConnection>
implements ConnectionHandlerAdapter<T> {
    private final ExtensionTransactionalResource<T> resource;

    public TransactionalConnectionHandler(ExtensionTransactionalResource<T> resource) {
        Preconditions.checkArgument(resource != null, "resource cannot be null");
        this.resource = resource;
    }

    @Override
    public T getConnection() throws ConnectionException {
        return this.resource.getConnection();
    }

    @Override
    public void release() {
    }

    @Override
    public synchronized void close() throws MuleException {
        ConnectionHandler<T> connectionHandler = this.resource.getConnectionHandler();
        Preconditions.checkArgument(connectionHandler instanceof ConnectionHandlerAdapter, "connectionHandlerAdapter was expected");
        if (!this.resource.isTransactionResolved()) {
            try {
                this.resource.rollback();
            }
            catch (Exception e) {
                throw new TransactionException(e);
            }
        }
        ((ConnectionHandlerAdapter)connectionHandler).close();
    }
}

