/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.spring.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.core.security.AbstractSecurityProvider;
import org.mule.runtime.module.spring.security.SpringAuthenticationAdapter;
import org.mule.runtime.module.spring.security.SpringAuthenticationProvider;
import org.mule.runtime.module.spring.security.SpringSecurityContextFactory;
import org.mule.runtime.module.spring.security.UserAndPasswordAuthenticationProvider;
import org.mule.runtime.module.spring.security.config.SecurityProperty;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class SpringProviderAdapter
extends AbstractSecurityProvider
implements AuthenticationProvider {
    private AuthenticationManager delegate;
    private Map securityProperties;
    private SpringAuthenticationProvider authenticationProvider;

    public SpringProviderAdapter() {
        super("spring-security");
    }

    public SpringProviderAdapter(AuthenticationManager delegate) {
        this(delegate, "spring-security");
    }

    public SpringProviderAdapter(AuthenticationManager delegate, String name) {
        super(name);
        this.delegate = delegate;
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.setSecurityContextFactory(new SpringSecurityContextFactory());
    }

    @Override
    public org.mule.runtime.api.security.Authentication authenticate(org.mule.runtime.api.security.Authentication authentication) throws SecurityException {
        Authentication auth = null;
        auth = authentication instanceof SpringAuthenticationAdapter ? ((SpringAuthenticationAdapter)authentication).getDelegate() : this.getAuthenticationProvider().getAuthentication(authentication);
        auth = this.delegate.authenticate(auth);
        return new SpringAuthenticationAdapter(auth, this.getSecurityProperties());
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        return this.delegate.authenticate(authentication);
    }

    public AuthenticationManager getDelegate() {
        return this.delegate;
    }

    public void setDelegate(AuthenticationManager delegate) {
        this.delegate = delegate;
    }

    public Map getSecurityProperties() {
        return this.securityProperties;
    }

    public void setSecurityProperties(List<SecurityProperty> securityProperties) {
        this.securityProperties = new HashMap();
        for (SecurityProperty securityProperty : securityProperties) {
            this.securityProperties.put(securityProperty.getName(), securityProperty.getValue());
        }
    }

    public SpringAuthenticationProvider getAuthenticationProvider() {
        if (this.authenticationProvider == null) {
            this.authenticationProvider = new UserAndPasswordAuthenticationProvider();
        }
        return this.authenticationProvider;
    }

    public void setAuthenticationProvider(SpringAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }
}

