/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.handler;

import java.util.Arrays;
import java.util.List;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.json.JsonTypeLoader;
import org.mule.metadata.json.handler.ArrayHandler;
import org.mule.metadata.json.handler.BooleanHandler;
import org.mule.metadata.json.handler.CombinedHandler;
import org.mule.metadata.json.handler.EmptyHandler;
import org.mule.metadata.json.handler.EnumHandler;
import org.mule.metadata.json.handler.NullHandler;
import org.mule.metadata.json.handler.NumberHandler;
import org.mule.metadata.json.handler.ObjectHandler;
import org.mule.metadata.json.handler.ParsingContext;
import org.mule.metadata.json.handler.ReferenceHandler;
import org.mule.metadata.json.handler.SchemaHandler;
import org.mule.metadata.json.handler.StringHandler;

public class HandlerManager {
    private List<? extends SchemaHandler> handlers = Arrays.asList(new ArrayHandler(), new BooleanHandler(), new CombinedHandler(), new EmptyHandler(), new EnumHandler(), new NullHandler(), new NumberHandler(), new ObjectHandler(), new ReferenceHandler(), new StringHandler());

    public TypeBuilder<?> handle(Schema schema, ParsingContext parsingContext) {
        if (parsingContext.isAlreadyBuild(schema)) {
            return parsingContext.getBuilder(schema).get();
        }
        for (SchemaHandler schemaHandler : this.handlers) {
            if (!schemaHandler.handles(schema)) continue;
            return schemaHandler.handle(schema, BaseTypeBuilder.create(JsonTypeLoader.JSON), this, parsingContext);
        }
        return BaseTypeBuilder.create(JsonTypeLoader.JSON).anyType();
    }
}

