/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.lang.SystemUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.notification.EnrichedNotificationInfo;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.ExceptionHandler;
import org.mule.runtime.core.component.ComponentAnnotations;
import org.mule.runtime.core.exception.ErrorMapping;
import org.mule.runtime.core.exception.ErrorTypeLocator;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.exception.Errors;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.exception.TypedException;
import org.mule.runtime.core.exception.WrapperErrorMessageAwareException;
import org.mule.runtime.core.message.ErrorBuilder;
import org.slf4j.Logger;

public class ExceptionUtils {
    public static boolean containsType(Throwable throwable, Class<?> type) {
        return org.apache.commons.lang.exception.ExceptionUtils.indexOfType((Throwable)throwable, type) > -1;
    }

    public static <ET> ET getDeepestOccurrenceOfType(Throwable throwable, Class<ET> type) {
        if (throwable == null || type == null) {
            return null;
        }
        List throwableList = org.apache.commons.lang.exception.ExceptionUtils.getThrowableList((Throwable)throwable);
        ListIterator listIterator = throwableList.listIterator(throwableList.size());
        while (listIterator.hasPrevious()) {
            Throwable candidate = (Throwable)listIterator.previous();
            if (!type.isAssignableFrom(candidate.getClass())) continue;
            return (ET)candidate;
        }
        return null;
    }

    public static String getFullStackTraceWithoutMessages(Throwable throwable) {
        StringBuilder builder = new StringBuilder();
        for (String frame : org.apache.commons.lang.exception.ExceptionUtils.getStackFrames((Throwable)throwable)) {
            builder.append(frame.replaceAll(":\\s+([\\w\\s]*.*)", "").trim()).append(SystemUtils.LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public static Optional<ConnectionException> extractConnectionException(Throwable throwable) {
        return ExceptionUtils.extractOfType(throwable, ConnectionException.class);
    }

    public static Optional<Throwable> extractCauseOfType(Throwable throwable, Class<? extends Throwable> throwableType) {
        Optional<? extends Throwable> typeThrowable = ExceptionUtils.extractOfType(throwable, throwableType);
        return typeThrowable.isPresent() ? Optional.ofNullable(typeThrowable.get().getCause()) : Optional.empty();
    }

    public static <T extends Throwable> Optional<T> extractOfType(Throwable throwable, Class<T> throwableType) {
        if (throwable == null || !ExceptionUtils.containsType(throwable, throwableType)) {
            return Optional.empty();
        }
        return Arrays.stream(org.apache.commons.lang.exception.ExceptionUtils.getThrowables((Throwable)throwable)).filter(throwableType::isInstance).findFirst();
    }

    public static <T, E extends Exception> T tryExpecting(Class<E> expectedExceptionType, Callable<T> callable, ExceptionHandler<T, E> exceptionHandler) throws E {
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (expectedExceptionType.isInstance(e)) {
                throw e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return exceptionHandler.handle(e);
        }
    }

    public static ErrorType getErrorTypeFromFailingProcessor(Object annotatedObject, Throwable exception, ErrorTypeLocator errorTypeLocator) {
        Optional<ErrorMapping> matchedErrorMapping;
        Throwable causeException = exception instanceof WrapperErrorMessageAwareException ? ((WrapperErrorMessageAwareException)exception).getRootCause() : exception;
        ComponentIdentifier componentIdentifier = null;
        List errorMappings = null;
        if (AnnotatedObject.class.isAssignableFrom(annotatedObject.getClass())) {
            componentIdentifier = (ComponentIdentifier)((AnnotatedObject)annotatedObject).getAnnotation(ComponentAnnotations.ANNOTATION_NAME);
            errorMappings = (List)((AnnotatedObject)annotatedObject).getAnnotation(ErrorMapping.ANNOTATION_ERROR_MAPPINGS);
        }
        ErrorType errorType = causeException instanceof TypedException ? ((TypedException)causeException).getErrorType() : (componentIdentifier != null ? errorTypeLocator.lookupComponentErrorType(componentIdentifier, causeException) : errorTypeLocator.lookupErrorType(causeException));
        if (errorMappings != null && !errorMappings.isEmpty() && (matchedErrorMapping = errorMappings.stream().filter(mapping -> mapping.match(errorType)).findFirst()).isPresent()) {
            return matchedErrorMapping.get().getTarget();
        }
        return errorType;
    }

    public static MessagingException putContext(MessagingException messagingException, Processor failingMessageProcessor, Event event, FlowConstruct flowConstruct, MuleContext muleContext) {
        EnrichedNotificationInfo notificationInfo = EnrichedNotificationInfo.createInfo(event, messagingException, null);
        for (ExceptionContextProvider exceptionContextProvider : muleContext.getExceptionContextProviders()) {
            for (Map.Entry<String, Object> contextInfoEntry : exceptionContextProvider.getContextInfo(notificationInfo, failingMessageProcessor, flowConstruct).entrySet()) {
                if (messagingException.getInfo().containsKey(contextInfoEntry.getKey())) continue;
                messagingException.getInfo().put(contextInfoEntry.getKey(), contextInfoEntry.getValue());
            }
        }
        return messagingException;
    }

    public static Event createErrorEvent(Event currentEvent, Object annotatedObject, MessagingException messagingException, ErrorTypeLocator errorTypeLocator) {
        Throwable causeException = messagingException.getCause() != null ? messagingException.getCause() : messagingException;
        Optional<Error> error = messagingException.getEvent().getError();
        if (!error.isPresent() || ExceptionUtils.errorCauseMatchesException(causeException, error) || !messagingException.causedExactlyBy(error.get().getCause().getClass())) {
            Error newError = ExceptionUtils.getErrorFromFailingProcessor(annotatedObject, causeException, errorTypeLocator);
            Event event = Event.builder(messagingException.getEvent()).error(newError).build();
            messagingException.setProcessedEvent(event);
            return event;
        }
        return currentEvent;
    }

    public static MessagingException updateMessagingException(Logger logger, Processor processor, MessagingException exception, ErrorTypeLocator errorTypeLocator, ErrorTypeRepository errorTypeRepository, FlowConstruct flowConstruct, MuleContext muleContext) {
        Exception rootException;
        Optional<Exception> rootExceptionOptional = ExceptionUtils.findRootExceptionForErrorHandling(exception, processor, errorTypeLocator, errorTypeRepository);
        if (rootExceptionOptional.isPresent()) {
            if (logger.isDebugEnabled()) {
                logger.debug("discarding exception that is wrapping the original error", (Throwable)exception);
            }
            if (rootExceptionOptional.get() instanceof MessagingException && ((MessagingException)rootExceptionOptional.get()).getEvent().getError().isPresent()) {
                return (MessagingException)rootExceptionOptional.get();
            }
            rootException = rootExceptionOptional.get();
        } else {
            rootException = exception;
        }
        Processor failing = exception.getFailingMessageProcessor();
        if (failing == null && rootException instanceof MessagingException) {
            failing = ((MessagingException)rootException).getFailingMessageProcessor();
        }
        if (failing == null) {
            failing = processor;
            exception = new MessagingException(I18nMessageFactory.createStaticMessage(rootException.getMessage()), exception.getEvent(), rootException instanceof MessagingException ? rootException.getCause() : rootException, processor);
        }
        exception.setProcessedEvent(ExceptionUtils.createErrorEvent(exception.getEvent(), processor, exception, errorTypeLocator));
        return ExceptionUtils.putContext(exception, failing, exception.getEvent(), flowConstruct, muleContext);
    }

    private static Optional<Exception> findRootExceptionForErrorHandling(Exception exception, Processor processor, ErrorTypeLocator errorTypeLocator, ErrorTypeRepository errorTypeRepository) {
        List<Throwable> causesAsList = ExceptionHelper.getExceptionsAsList(exception);
        for (Throwable cause : causesAsList) {
            if (!(cause instanceof MessagingException) || !((MessagingException)cause).getEvent().getError().isPresent()) continue;
            return Optional.of((Exception)cause);
        }
        int causeIndex = 0;
        for (Throwable cause : causesAsList) {
            ErrorType unknownErrorType;
            ErrorType errorType;
            if (cause instanceof TypedException) {
                return Optional.of((Exception)cause);
            }
            if ((cause instanceof MuleException || cause instanceof MuleRuntimeException) && !(errorType = errorTypeLocator.lookupErrorType(cause)).equals(unknownErrorType = errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.UNKNOWN).get())) {
                Throwable causeOwnerException;
                ErrorType causeOwnerErrorType;
                ComponentLocation componentLocation;
                int nextCauseIndex = causeIndex + 1;
                ComponentLocation componentLocation2 = componentLocation = processor instanceof AnnotatedObject ? ((AnnotatedObject)((Object)processor)).getLocation() : null;
                if (causesAsList.size() > nextCauseIndex && componentLocation != null && !unknownErrorType.equals(causeOwnerErrorType = (causeOwnerException = causesAsList.get(nextCauseIndex)) instanceof TypedException ? ((TypedException)causeOwnerException).getErrorType() : errorTypeLocator.lookupComponentErrorType(componentLocation.getComponentIdentifier().getIdentifier(), causeOwnerException)) && new SingleErrorTypeMatcher(errorType).match(causeOwnerErrorType)) {
                    return Optional.of((Exception)causeOwnerException);
                }
                return Optional.of((Exception)cause);
            }
            ++causeIndex;
        }
        return Optional.empty();
    }

    static boolean errorCauseMatchesException(Throwable causeException, Optional<Error> error) {
        Throwable throwable = causeException instanceof TypedException ? causeException.getCause() : causeException;
        return !error.get().getCause().equals(throwable);
    }

    public static Error getErrorFromFailingProcessor(Object annotatedObject, Throwable causeException, ErrorTypeLocator errorTypeLocator) {
        ErrorType errorType = ExceptionUtils.getErrorTypeFromFailingProcessor(annotatedObject, causeException, errorTypeLocator);
        if (causeException instanceof TypedException) {
            causeException = causeException.getCause();
        }
        return ErrorBuilder.builder(causeException).errorType(errorType).build();
    }

    public static Throwable getRootCauseException(Throwable exception) {
        return exception instanceof ErrorMessageAwareException ? ((ErrorMessageAwareException)((Object)exception)).getRootCause() : exception;
    }

    public static MessagingException updateMessagingExceptionWithError(MessagingException exception, Processor failing, FlowConstruct flowConstruct) {
        if (!exception.getEvent().getError().isPresent()) {
            exception.setProcessedEvent(ExceptionUtils.createErrorEvent(exception.getEvent(), failing, exception, flowConstruct.getMuleContext().getErrorTypeLocator()));
        }
        return ExceptionUtils.putContext(exception, failing, exception.getEvent(), flowConstruct, flowConstruct.getMuleContext());
    }
}

