/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashSet
extends AbstractSet
implements Set,
Serializable {
    private static final long serialVersionUID = 2454657854757543876L;
    private final ConcurrentHashMap map;
    private transient Set keySet;

    public ConcurrentHashSet() {
        this.map = new ConcurrentHashMap();
        this.keySet = this.map.keySet();
    }

    public ConcurrentHashSet(int initialCapacity) {
        this.map = new ConcurrentHashMap(initialCapacity);
        this.keySet = this.map.keySet();
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        this.keySet = this.map.keySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator iterator() {
        return this.keySet.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.keySet.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.keySet.toArray(a);
    }

    @Override
    public boolean add(Object e) {
        return this.map.put(e, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.keySet.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.keySet.retainAll(c);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.keySet.equals(o);
    }

    @Override
    public int hashCode() {
        return this.keySet.hashCode();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.keySet = this.map.keySet();
    }
}

