/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.InputStream;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.core.internal.streaming.bytes.AbstractCursorStreamProvider;
import org.mule.runtime.core.internal.streaming.bytes.BufferedCursorStream;
import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.InMemoryStreamBuffer;
import org.mule.runtime.core.streaming.bytes.InMemoryCursorStreamConfig;

public class InMemoryCursorStreamProvider
extends AbstractCursorStreamProvider {
    private final InMemoryStreamBuffer buffer;

    public InMemoryCursorStreamProvider(InputStream wrappedStream, InMemoryCursorStreamConfig config, ByteBufferManager bufferManager) {
        super(wrappedStream);
        this.buffer = new InMemoryStreamBuffer(wrappedStream, config, bufferManager);
    }

    @Override
    protected CursorStream doOpenCursor() {
        return new BufferedCursorStream(this.buffer, this);
    }

    @Override
    public void releaseResources() {
        if (this.buffer != null) {
            this.buffer.close();
        }
    }
}

