/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.store.ListableObjectStore;
import org.mule.runtime.core.exception.MessagingExceptionHandlerToSystemAdapter;
import org.mule.runtime.core.routing.AsynchronousUntilSuccessfulProcessingStrategy;
import org.mule.runtime.core.routing.SynchronousUntilSuccessfulProcessingStrategy;
import org.mule.runtime.core.routing.UntilSuccessfulConfiguration;
import org.mule.runtime.core.routing.UntilSuccessfulProcessingStrategy;
import org.mule.runtime.core.routing.filters.ExpressionFilter;
import org.mule.runtime.core.routing.outbound.AbstractOutboundRouter;

public class UntilSuccessful
extends AbstractOutboundRouter
implements UntilSuccessfulConfiguration {
    public static final String PROCESS_ATTEMPT_COUNT_PROPERTY_NAME = "process.attempt.count";
    static final int DEFAULT_PROCESS_ATTEMPT_COUNT_PROPERTY_VALUE = 1;
    private static final long DEFAULT_MILLIS_BETWEEN_RETRIES = 60000L;
    private ListableObjectStore<Event> objectStore;
    private int maxRetries = 5;
    private Long millisBetweenRetries = null;
    private Long secondsBetweenRetries = null;
    private String failureExpression;
    private String ackExpression;
    private ExpressionFilter failureExpressionFilter;
    private String eventKeyPrefix;
    protected Processor dlqMP;
    private boolean synchronous = false;
    private UntilSuccessfulProcessingStrategy untilSuccessfulStrategy;

    @Override
    public void initialise() throws InitialisationException {
        if (this.routes.isEmpty()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("One message processor must be configured within UntilSuccessful."), (Initialisable)this);
        }
        if (this.routes.size() > 1) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Only one message processor is allowed within UntilSuccessful. Use a Processor Chain to group several message processors into one."), (Initialisable)this);
        }
        this.setWaitTime();
        if (this.messagingExceptionHandler == null) {
            this.messagingExceptionHandler = new MessagingExceptionHandlerToSystemAdapter(this.muleContext);
        }
        super.initialise();
        this.failureExpressionFilter = this.failureExpression != null ? new ExpressionFilter(this.failureExpression) : new ExpressionFilter("exception != null");
        this.failureExpressionFilter.setMuleContext(this.muleContext);
        if (this.ackExpression != null && !this.muleContext.getExpressionManager().isExpression(this.ackExpression)) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Invalid ackExpression: " + this.ackExpression), (Initialisable)this);
        }
        if (this.synchronous) {
            this.untilSuccessfulStrategy = new SynchronousUntilSuccessfulProcessingStrategy();
        } else {
            this.untilSuccessfulStrategy = new AsynchronousUntilSuccessfulProcessingStrategy();
            ((MessagingExceptionHandlerAware)((Object)this.untilSuccessfulStrategy)).setMessagingExceptionHandler(this.messagingExceptionHandler);
        }
        this.untilSuccessfulStrategy.setUntilSuccessfulConfiguration(this);
        LifecycleUtils.initialiseIfNeeded(this.untilSuccessfulStrategy, this.muleContext);
        String flowName = this.flowConstruct.getName();
        String clusterId = this.muleContext.getClusterId();
        this.eventKeyPrefix = flowName + "-" + clusterId + "-";
    }

    private void setWaitTime() {
        boolean hasSeconds = this.secondsBetweenRetries != null;
        boolean hasMillis = this.millisBetweenRetries != null;
        Preconditions.checkArgument(!hasSeconds || !hasMillis, "Can't specify millisBetweenRetries and secondsBetweenRetries properties at the same time. Please specify only one and remember that secondsBetweenRetries is deprecated.");
        if (hasSeconds) {
            this.logger.warn("You're using the secondsBetweenRetries in the until-successful router. That attribute was deprecated in favor of the new millisBetweenRetries.Please consider updating your config since the old attribute will be removed in Mule 4");
            this.setMillisBetweenRetries(TimeUnit.SECONDS.toMillis(this.secondsBetweenRetries));
        } else if (!hasMillis) {
            this.millisBetweenRetries = 60000L;
        }
    }

    @Override
    public void start() throws MuleException {
        super.start();
        if (this.untilSuccessfulStrategy instanceof Startable) {
            ((Startable)((Object)this.untilSuccessfulStrategy)).start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.untilSuccessfulStrategy instanceof Stoppable) {
            ((Stoppable)((Object)this.untilSuccessfulStrategy)).stop();
        }
        super.stop();
    }

    @Override
    public boolean isMatch(Event event, Event.Builder builder) throws MuleException {
        return true;
    }

    @Override
    protected Event route(Event event) throws MuleException {
        return this.untilSuccessfulStrategy.route(event, this.flowConstruct);
    }

    @Override
    public ListableObjectStore<Event> getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ListableObjectStore<Event> objectStore) {
        this.objectStore = objectStore;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    @Deprecated
    public void setSecondsBetweenRetries(long secondsBetweenRetries) {
        this.secondsBetweenRetries = secondsBetweenRetries;
    }

    @Override
    public long getMillisBetweenRetries() {
        return this.millisBetweenRetries;
    }

    public void setMillisBetweenRetries(long millisBetweenRetries) {
        this.millisBetweenRetries = millisBetweenRetries;
    }

    public String getFailureExpression() {
        return this.failureExpression;
    }

    public void setFailureExpression(String failureExpression) {
        this.failureExpression = failureExpression;
    }

    @Override
    public String getAckExpression() {
        return this.ackExpression;
    }

    public void setAckExpression(String ackExpression) {
        this.ackExpression = ackExpression;
    }

    public String getEventKeyPrefix() {
        return this.eventKeyPrefix;
    }

    @Override
    public ExpressionFilter getFailureExpressionFilter() {
        return this.failureExpressionFilter;
    }

    @Override
    public Processor getDlqMP() {
        return this.dlqMP;
    }

    @Override
    public Processor getRoute() {
        MessageProcessorChain chain = MessageProcessors.newChain(MessageProcessors.newExplicitChain((Processor)this.routes.get(0)));
        chain.setMuleContext(this.muleContext);
        chain.setFlowConstruct(this.flowConstruct);
        return chain;
    }

    @Override
    public AbstractOutboundRouter getRouter() {
        return this;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }
}

