/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing.outbound;

import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.runtime.core.api.routing.RoutePathNotFoundException;
import org.mule.runtime.core.api.routing.RoutingException;
import org.mule.runtime.core.api.routing.TransformingMatchable;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.util.TemplateParser;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.routing.outbound.AbstractOutboundRouter;

public class FilteringOutboundRouter
extends AbstractOutboundRouter
implements TransformingMatchable {
    protected MuleExpressionLanguage expressionManager;
    private List<Transformer> transformers = new LinkedList<Transformer>();
    private Filter filter;
    private boolean useTemplates = true;
    protected TemplateParser parser = TemplateParser.createSquareBracesStyleParser();

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    @Override
    public Event route(Event event) throws RoutingException {
        Event result;
        Message message = event.getMessage();
        if (this.routes == null || this.routes.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), null);
        }
        Processor ep = this.getRoute(0, event);
        try {
            result = this.sendRequest(event, this.createEventToRoute(event, message), ep, true);
        }
        catch (RoutingException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException(ep, (Throwable)e);
        }
        return result;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public boolean isMatch(Event event, Event.Builder builder) throws MuleException {
        if (this.getFilter() == null) {
            return true;
        }
        Message message = this.muleContext.getTransformationService().applyTransformers(event.getMessage(), null, this.transformers);
        event = Event.builder(event).message(message).build();
        builder.message(message);
        return this.getFilter().accept(event, builder);
    }

    public List<Transformer> getTransformers() {
        return this.transformers;
    }

    public void setTransformers(List<Transformer> transformers) {
        this.transformers = transformers;
    }

    public Processor getRoute(int index, Event event) throws CouldNotRouteOutboundMessageException {
        if (!this.useTemplates) {
            return (Processor)this.routes.get(index);
        }
        return this.getTemplateRoute(index, event);
    }

    protected Processor getTemplateRoute(int index, Event event) throws CouldNotRouteOutboundMessageException {
        return (Processor)this.routes.get(index);
    }

    public boolean isUseTemplates() {
        return this.useTemplates;
    }

    public void setUseTemplates(boolean useTemplates) {
        this.useTemplates = useTemplates;
    }

    @Override
    public boolean isTransformBeforeMatch() {
        return !this.transformers.isEmpty();
    }
}

