/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.xmlsecurity;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import net.sf.saxon.jaxp.SaxonTransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultXMLSecureFactories {
    private static final Log logger = LogFactory.getLog(DefaultXMLSecureFactories.class);

    public static DocumentBuilderFactory createDocumentBuilderFactory(Boolean externalEntities, Boolean expandEntities) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", externalEntities);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", externalEntities);
            factory.setExpandEntityReferences(expandEntities);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", expandEntities == false);
        }
        catch (Exception e) {
            DefaultXMLSecureFactories.logWarning("DocumentBuilderFactory", factory.getClass().getName());
        }
        return factory;
    }

    public static SAXParserFactory createSaxParserFactory(Boolean externalEntities, Boolean expandEntities) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", externalEntities);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", externalEntities);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", expandEntities == false);
        }
        catch (Exception e) {
            DefaultXMLSecureFactories.logWarning("SAXParserFactory", factory.getClass().getName());
        }
        return factory;
    }

    public static XMLInputFactory createXmlInputFactory(Boolean externalEntities, Boolean expandEntities) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", externalEntities);
        factory.setProperty("javax.xml.stream.supportDTD", expandEntities);
        return factory;
    }

    public static TransformerFactory createTransformerFactory(Boolean externalEntities, Boolean expandEntities) {
        TransformerFactory factory = TransformerFactory.newInstance();
        DefaultXMLSecureFactories.configureTransformerFactory(externalEntities, expandEntities, factory);
        return factory;
    }

    public static void configureTransformerFactory(Boolean externalEntities, Boolean expandEntities, TransformerFactory factory) {
        if (!externalEntities.booleanValue() && !expandEntities.booleanValue()) {
            try {
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            }
            catch (Exception e) {
                try {
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (TransformerConfigurationException e1) {
                    DefaultXMLSecureFactories.logWarning("TransformerFactory", factory.getClass().getName());
                }
            }
        }
    }

    public static TransformerFactory createSaxonTransformerFactory(Boolean externalEntities, Boolean expandEntities) {
        SaxonTransformerFactory factory = new SaxonTransformerFactory();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", externalEntities == false && expandEntities == false);
        }
        catch (TransformerConfigurationException e) {
            DefaultXMLSecureFactories.logWarning("SaxonTransformerFactory", factory.getClass().getName());
        }
        return factory;
    }

    protected static void logWarning(String interfaceName, String implementationName) {
        logger.warn((Object)String.format("Can't configure XML entity expansion for %s (%s), this could introduce XXE and BL vulnerabilities", interfaceName, implementationName));
    }
}

