/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.streaming.CursorProviderFactory;
import org.mule.runtime.core.streaming.StreamingManager;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.source.SourceCompletionCallback;
import org.mule.runtime.module.extension.internal.loader.java.property.SourceCallbackModelProperty;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.execution.ReflectiveMethodComponentExecutor;
import org.mule.runtime.module.extension.internal.runtime.source.ReactorSourceCompletionCallback;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackExecutor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

class ReflectiveSourceCallbackExecutor
implements SourceCallbackExecutor {
    private final ExtensionModel extensionModel;
    private final Optional<ConfigurationInstance> configurationInstance;
    private final SourceModel sourceModel;
    private final CursorProviderFactory cursorProviderFactory;
    private final StreamingManager streamingManager;
    private final MuleContext muleContext;
    private final boolean async;
    private final ReflectiveMethodComponentExecutor<SourceModel> executor;

    public ReflectiveSourceCallbackExecutor(ExtensionModel extensionModel, Optional<ConfigurationInstance> configurationInstance, SourceModel sourceModel, Object source, Method method, CursorProviderFactory cursorProviderFactory, StreamingManager streamingManager, MuleContext muleContext, SourceCallbackModelProperty sourceCallbackModel) {
        this.extensionModel = extensionModel;
        this.configurationInstance = configurationInstance;
        this.sourceModel = sourceModel;
        this.cursorProviderFactory = cursorProviderFactory;
        this.streamingManager = streamingManager;
        this.muleContext = muleContext;
        this.executor = new ReflectiveMethodComponentExecutor(this.getAllGroups(sourceModel, method, sourceCallbackModel), method, source);
        this.async = Stream.of(method.getParameterTypes()).anyMatch(p -> SourceCompletionCallback.class.equals(p));
    }

    @Override
    public Publisher<Void> execute(Event event, Map<String, Object> parameters, SourceCallbackContext context) {
        if (this.async) {
            return Mono.create(sink -> {
                ExecutionContext<SourceModel> executionContext = this.createExecutionContext(event, parameters, context, new ReactorSourceCompletionCallback((MonoSink<Void>)sink));
                try {
                    this.executor.execute(executionContext);
                }
                catch (Throwable t) {
                    sink.error(Exceptions.wrapFatal(t));
                }
            });
        }
        try {
            this.executor.execute(this.createExecutionContext(event, parameters, context, null));
            return Mono.empty();
        }
        catch (Throwable t) {
            return Mono.error((Throwable)Exceptions.wrapFatal(t));
        }
    }

    private ExecutionContext<SourceModel> createExecutionContext(Event event, Map<String, Object> parameters, SourceCallbackContext callbackContext, SourceCompletionCallback sourceCompletionCallback) {
        DefaultExecutionContext<SourceModel> executionContext = new DefaultExecutionContext<SourceModel>(this.extensionModel, this.configurationInstance, parameters, this.sourceModel, event, this.cursorProviderFactory, this.streamingManager, this.muleContext);
        executionContext.setVariable("MULE_SOURCE_CALLBACK_CONTEXT_PARAM", callbackContext);
        if (sourceCompletionCallback != null) {
            executionContext.setVariable("MULE_SOURCE_COMPLETION_CALLBACK_PARAM", sourceCompletionCallback);
        }
        return executionContext;
    }

    private List<ParameterGroupModel> getAllGroups(SourceModel model, Method method, SourceCallbackModelProperty sourceCallbackModel) {
        List callbackParameters = sourceCallbackModel.getOnSuccessMethod().filter(method::equals).map(m -> this.sourceModel.getSuccessCallback().get().getParameterGroupModels()).orElseGet(() -> sourceCallbackModel.getOnErrorMethod().filter(method::equals).map(m -> this.sourceModel.getErrorCallback().get().getParameterGroupModels()).orElseGet(() -> this.sourceModel.getTerminateCallback().get().getParameterGroupModels()));
        return ImmutableList.builder().addAll(model.getParameterGroupModels()).addAll((Iterable)callbackParameters).build();
    }
}

