/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.DateTimeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.xml.handler.XmlHandler;
import org.mule.metadata.xml.utils.XmlConstants;

public class DateTimeHandler
implements XmlHandler {
    public static final List<QName> DATE_TIME_TYPES = Arrays.asList(XmlConstants.XSD_DATETIME);

    @Override
    public boolean handles(QName schema) {
        return DATE_TIME_TYPES.contains(schema);
    }

    @Override
    public TypeBuilder<?> handle(XSSimpleTypeDecl xsTypeDefinition, Optional<String> defaultValue, BaseTypeBuilder builder) {
        DateTimeBuilder dateTimeType = builder.dateTimeType();
        if (defaultValue.isPresent() && !defaultValue.get().isEmpty()) {
            dateTimeType.defaultValue(defaultValue.get());
        }
        return dateTimeType;
    }
}

