/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Stack;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.config.spring.ElementValidator;
import org.mule.runtime.config.spring.MuleHierarchicalBeanDefinitionParserDelegate;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.spring.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.spring.dsl.processor.ConfigFile;
import org.mule.runtime.config.spring.dsl.processor.ConfigLine;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.config.spring.dsl.spring.BeanDefinitionFactory;
import org.mule.runtime.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MuleBeanDefinitionDocumentReader
extends DefaultBeanDefinitionDocumentReader {
    private final BeanDefinitionFactory beanDefinitionFactory;
    private final XmlApplicationParser xmlApplicationParser;
    private final Stack<ApplicationModel> applicationModelStack = new Stack();
    private final ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry;

    public MuleBeanDefinitionDocumentReader(BeanDefinitionFactory beanDefinitionFactory, XmlApplicationParser xmlApplicationParser, ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry) {
        this.beanDefinitionFactory = beanDefinitionFactory;
        this.xmlApplicationParser = xmlApplicationParser;
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
    }

    protected BeanDefinitionParserDelegate createDelegate(XmlReaderContext readerContext, Element root, BeanDefinitionParserDelegate parentDelegate) {
        MuleHierarchicalBeanDefinitionParserDelegate delegate = this.createBeanDefinitionParserDelegate(readerContext);
        delegate.initDefaults(root, parentDelegate);
        return delegate;
    }

    protected MuleHierarchicalBeanDefinitionParserDelegate createBeanDefinitionParserDelegate(XmlReaderContext readerContext) {
        return new MuleHierarchicalBeanDefinitionParserDelegate(readerContext, this, this.applicationModelStack::peek, this.beanDefinitionFactory, this.getElementsValidator());
    }

    protected ElementValidator[] getElementsValidator() {
        return new ElementValidator[0];
    }

    protected void parseBeanDefinitions(Element root, BeanDefinitionParserDelegate delegate) {
        if (!StringUtils.hasLength((String)root.getNamespaceURI())) {
            this.getReaderContext().error("Unable to locate NamespaceHandler for namespace [null]", (Object)root);
        } else {
            super.parseBeanDefinitions(root, delegate);
        }
    }

    protected void preProcessXml(Element root) {
        try {
            ArrayList<ConfigLine> configLines = new ArrayList<ConfigLine>();
            configLines.add(this.xmlApplicationParser.parse(root).get());
            ArtifactConfig artifactConfig = new ArtifactConfig.Builder().addConfigFile(new ConfigFile(AbstractMuleBeanDefinitionParser.getConfigFileIdentifier(this.getReaderContext().getResource()), configLines)).build();
            this.applicationModelStack.push(new ApplicationModel(artifactConfig, new ArtifactDeclaration(), Collections.emptySet(), Optional.of(this.componentBuildingDefinitionRegistry)));
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }

    protected void postProcessXml(Element root) {
        this.applicationModelStack.pop();
    }
}

