/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.execution;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.NullAttributes;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.exception.ErrorTypeMatcher;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.exception.Errors;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.execution.MessageProcessContext;
import org.mule.runtime.core.execution.MessageProcessPhase;
import org.mule.runtime.core.execution.MessageProcessTemplate;
import org.mule.runtime.core.execution.ModuleFlowProcessingPhaseTemplate;
import org.mule.runtime.core.execution.NotificationFiringProcessingPhase;
import org.mule.runtime.core.execution.PhaseResultNotifier;
import org.mule.runtime.core.execution.ResponseCompletionCallback;
import org.mule.runtime.core.execution.SourceErrorException;
import org.mule.runtime.core.execution.SourceResultAdapter;
import org.mule.runtime.core.execution.TransactionalErrorHandlingExecutionTemplate;
import org.mule.runtime.core.execution.ValidationPhase;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.core.message.ErrorBuilder;
import org.mule.runtime.core.policy.FailureSourcePolicyResult;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.policy.SourcePolicy;
import org.mule.runtime.core.policy.SuccessSourcePolicyResult;
import org.mule.runtime.core.transaction.MuleTransactionConfig;
import org.mule.runtime.core.util.message.MessageUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class ModuleFlowProcessingPhase
extends NotificationFiringProcessingPhase<ModuleFlowProcessingPhaseTemplate>
implements Initialisable {
    public static final String ENABLE_SOURCE_POLICIES_SYSTEM_PROPERTY = "enableSourcePolicies";
    private static Logger LOGGER = LoggerFactory.getLogger(ModuleFlowProcessingPhase.class);
    private boolean enableSourcePolicies;
    private ErrorTypeMatcher sourceResponseErrorTypeMatcher;
    private ErrorType sourceResponseGenerateErrorType;
    private ErrorType sourceResponseSendErrorType;
    private ErrorType sourceErrorResponseGenerateErrorType;
    private ErrorType sourceErrorResponseSendErrorType;
    private final PolicyManager policyManager;

    public ModuleFlowProcessingPhase(PolicyManager policyManager) {
        this.policyManager = policyManager;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.enableSourcePolicies = System.getProperty(ENABLE_SOURCE_POLICIES_SYSTEM_PROPERTY) != null;
        ErrorTypeRepository errorTypeRepository = this.muleContext.getErrorTypeRepository();
        this.sourceResponseErrorTypeMatcher = new SingleErrorTypeMatcher(errorTypeRepository.getSourceResponseErrorType());
        this.sourceResponseGenerateErrorType = errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.SOURCE_RESPONSE_GENERATE).get();
        this.sourceResponseSendErrorType = errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.SOURCE_RESPONSE_SEND).get();
        this.sourceErrorResponseGenerateErrorType = errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.SOURCE_ERROR_RESPONSE_GENERATE).get();
        this.sourceErrorResponseSendErrorType = errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.SOURCE_ERROR_RESPONSE_SEND).get();
    }

    @Override
    public boolean supportsTemplate(MessageProcessTemplate messageProcessTemplate) {
        return messageProcessTemplate instanceof ModuleFlowProcessingPhaseTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runPhase(ModuleFlowProcessingPhaseTemplate template, MessageProcessContext messageProcessContext, PhaseResultNotifier phaseResultNotifier) {
        block6: {
            try {
                MessagingExceptionHandler exceptionHandler = messageProcessContext.getFlowConstruct().getExceptionListener();
                MessageSource messageSource = messageProcessContext.getMessageSource();
                ComponentLocation sourceLocation = messageSource.getLocation();
                CheckedFunction<MessagingException, Publisher<Void>> errorHandler = this.onError(messageSource, template.getFailedExecutionResponseParametersFunction(), messageProcessContext, template, phaseResultNotifier);
                Consumer<Either<MessagingException, Event>> terminateConsumer = this.getTerminateConsumer(messageSource, template);
                MonoProcessor responseCompletion = MonoProcessor.create();
                Event templateEvent = this.createEvent(template, messageProcessContext, sourceLocation, (Publisher<Void>)responseCompletion);
                if (!this.enableSourcePolicies) {
                    Mono.just((Object)templateEvent).doOnNext(request -> this.fireNotification(messageProcessContext.getMessageSource(), (Event)request, messageProcessContext.getFlowConstruct(), 801)).then(request -> Mono.from(template.routeEventAsync((Event)request)).switchIfEmpty(Mono.fromCallable(() -> this.emptyEvent(templateEvent)))).then(this.onSuccess(messageSource, templateEvent, messageProcessContext, phaseResultNotifier, template, terminateConsumer)).onErrorMap(MessagingException.class, me -> me.getCause() instanceof SourceErrorException ? me.getCause() : me).onErrorResume(SourceErrorException.class, see -> this.onSourceException(exceptionHandler, (Function<MessagingException, Publisher<Void>>)errorHandler, terminateConsumer, (SourceErrorException)see)).onErrorResume(MessagingException.class, me -> Mono.from((Publisher)((Publisher)errorHandler.apply((MessagingException)me))).doOnSuccess(v -> this.onTerminate(terminateConsumer, Either.left(me))).doOnError(e -> this.onTerminate(terminateConsumer, Either.left(e)))).doAfterTerminate((event, throwable) -> responseCompletion.onComplete()).subscribe();
                    break block6;
                }
                Processor nextOperation = this.createFlowExecutionProcessor(messageSource, exceptionHandler, messageProcessContext, template);
                SourcePolicy policy = this.policyManager.createSourcePolicyInstance(sourceLocation, templateEvent, nextOperation, template);
                try {
                    Consumer<FailureSourcePolicyResult> onFailureFunction = failureSourcePolicyResult -> {
                        MessagingException messagingException = failureSourcePolicyResult.getMessagingException();
                        try {
                            ErrorType errorType = messagingException.getEvent().getError().orElseGet(() -> ErrorBuilder.builder(messagingException.getCause()).errorType(this.sourceResponseGenerateErrorType).build()).getErrorType();
                            Mono.from((Publisher)((Publisher)errorHandler.apply(messagingException))).doOnSuccess(v -> {
                                if (this.sourceResponseErrorTypeMatcher.match(errorType)) {
                                    this.onTerminate(terminateConsumer, Either.right(messagingException.getEvent()));
                                } else {
                                    this.onTerminate(terminateConsumer, Either.left(new SourceErrorException(messagingException.getEvent(), errorType, messagingException).toMessagingException()));
                                }
                            }).doOnError(SourceErrorException.class, see -> this.onTerminate(terminateConsumer, Either.left(see.toMessagingException()))).subscribe();
                        }
                        catch (SourceErrorException see2) {
                            this.onTerminate(terminateConsumer, Either.left(see2.toMessagingException()));
                        }
                    };
                    Consumer<SuccessSourcePolicyResult> onSuccessFunction = successSourcePolicyResult -> {
                        Event flowExecutionResponse = successSourcePolicyResult.getFlowExecutionResult();
                        this.fireNotification(messageSource, flowExecutionResponse, messageProcessContext.getFlowConstruct(), 805);
                        if (flowExecutionResponse == null) {
                            flowExecutionResponse = this.emptyEvent(templateEvent);
                        }
                        Map<String, Object> responseParameters = successSourcePolicyResult.getResponseParameters();
                        Event finalResponse = flowExecutionResponse;
                        Mono.from(template.sendResponseToClient(flowExecutionResponse, responseParameters, failureEvent -> successSourcePolicyResult.createErrorResponseParameters((Event)failureEvent), this.createResponseCompletationCallback(phaseResultNotifier))).onErrorResume(SourceErrorException.class, see -> Mono.from((Publisher)((Publisher)errorHandler.apply(see.toMessagingException()))).doOnSuccess(v -> this.onTerminate(terminateConsumer, Either.left(see)))).doAfterTerminate((v, e) -> this.onTerminate(terminateConsumer, Either.right(finalResponse))).subscribe();
                    };
                    policy.process(templateEvent).apply(onFailureFunction, onSuccessFunction);
                }
                finally {
                    this.policyManager.disposePoliciesResources(templateEvent.getContext().getId());
                }
            }
            catch (Exception e) {
                phaseResultNotifier.phaseFailure(e);
            }
        }
    }

    private Mono<Void> onSourceException(MessagingExceptionHandler exceptionHandler, Function<MessagingException, Publisher<Void>> errorHandler, Consumer<Either<MessagingException, Event>> terminateConsumer, SourceErrorException see) {
        if (this.sourceResponseErrorTypeMatcher.match(see.getErrorType())) {
            return Mono.from(this.handleSourceError(exceptionHandler, errorHandler, see)).doOnSuccess(v -> this.onTerminate(terminateConsumer, Either.right(see.getEvent()))).doOnError(e -> this.onTerminate(terminateConsumer, Either.left(e)));
        }
        return Mono.error((Throwable)see);
    }

    private Publisher<Void> handleSourceError(MessagingExceptionHandler exceptionHandler, Function<MessagingException, Publisher<Void>> errorConsumer, SourceErrorException see) {
        MessagingException messagingException = see.toMessagingException();
        exceptionHandler.handleException(messagingException, messagingException.getEvent());
        return errorConsumer.apply(messagingException);
    }

    private Event createEvent(ModuleFlowProcessingPhaseTemplate template, MessageProcessContext messageProcessContext, ComponentLocation sourceLocation, Publisher<Void> responseCompletion) throws MuleException {
        Message message = template.getMessage();
        Event templateEvent = Event.builder(DefaultEventContext.create(messageProcessContext.getFlowConstruct(), sourceLocation, null, responseCompletion)).message(message).flow(messageProcessContext.getFlowConstruct()).build();
        if (message.getPayload().getValue() instanceof SourceResultAdapter) {
            SourceResultAdapter adapter = (SourceResultAdapter)message.getPayload().getValue();
            Result result = adapter.getResult();
            Object resultValue = result.getOutput();
            message = resultValue instanceof Collection && adapter.isCollection() ? MessageUtils.toMessage(Result.builder().output(MessageUtils.toMessageCollection((Collection)resultValue, adapter.getCursorProviderFactory(), templateEvent)).attributes(NullAttributes.NULL_ATTRIBUTES).mediaType(result.getMediaType().orElse(MediaType.ANY)).build()) : MessageUtils.toMessage(result, result.getMediaType().orElse(MediaType.ANY), adapter.getCursorProviderFactory(), templateEvent);
            templateEvent = Event.builder(templateEvent).message(message).build();
        }
        return templateEvent;
    }

    private CheckedFunction<MessagingException, Publisher<Void>> onError(MessageSource messageSource, Function<Event, Map<String, Object>> errorParametersFunction, MessageProcessContext messageProcessContext, ModuleFlowProcessingPhaseTemplate template, PhaseResultNotifier phaseResultNotifier) {
        return messagingException -> {
            Map parameters;
            Event errorEvent = ExceptionUtils.createErrorEvent(messagingException.getEvent(), messageSource, messagingException, this.muleContext.getErrorTypeLocator());
            messagingException.setProcessedEvent(errorEvent);
            this.fireNotification(messageSource, messagingException.getEvent(), messageProcessContext.getFlowConstruct(), 806);
            if (messagingException.inErrorHandler()) {
                phaseResultNotifier.phaseFailure((Exception)messagingException.getCause());
                SourceErrorException exception = new SourceErrorException(messagingException.getEvent(), this.sourceErrorResponseGenerateErrorType, messagingException.getCause(), (MessagingException)messagingException);
                return Mono.error((Throwable)exception);
            }
            try {
                parameters = (Map)errorParametersFunction.apply(messagingException.getEvent());
            }
            catch (Exception e) {
                phaseResultNotifier.phaseFailure(e);
                return Mono.error((Throwable)new SourceErrorException(errorEvent, this.sourceErrorResponseGenerateErrorType, e, (MessagingException)messagingException));
            }
            return template.sendFailureResponseToClient((MessagingException)messagingException, parameters, this.createSendFailureResponseCompletationCallback(phaseResultNotifier, this.sourceErrorResponseSendErrorType));
        };
    }

    private Consumer<Either<MessagingException, Event>> getTerminateConsumer(MessageSource messageSource, ModuleFlowProcessingPhaseTemplate template) {
        return eventOrException -> template.sendAfterTerminateResponseToClient(eventOrException.mapLeft(messagingException -> {
            messagingException.setProcessedEvent(ExceptionUtils.createErrorEvent(messagingException.getEvent(), messageSource, messagingException, this.muleContext.getErrorTypeLocator()));
            return messagingException;
        }));
    }

    private Function<Event, Mono<Void>> onSuccess(MessageSource messageSource, Event request, MessageProcessContext messageProcessContext, PhaseResultNotifier phaseResultNotifier, ModuleFlowProcessingPhaseTemplate template, Consumer<Either<MessagingException, Event>> terminateConsumer) {
        return response -> {
            Map<String, Object> responseParameters;
            this.fireNotification(messageSource, (Event)response, messageProcessContext.getFlowConstruct(), 805);
            if (response == null) {
                response = this.emptyEvent(request);
            }
            try {
                responseParameters = template.getSuccessfulExecutionResponseParametersFunction().apply((Event)response);
            }
            catch (Exception e) {
                return Mono.error((Throwable)new SourceErrorException((Event)response, this.sourceResponseGenerateErrorType, e));
            }
            Event finalResponse = response;
            return Mono.from(template.sendResponseToClient((Event)response, responseParameters, (Function<Event, Map<String, Object>>)template.getFailedExecutionResponseParametersFunction(), this.createResponseCompletationCallback(phaseResultNotifier))).doOnSuccess(v -> this.onTerminate(terminateConsumer, Either.right(finalResponse)));
        };
    }

    private Event emptyEvent(Event request) {
        return Event.builder(request).message(Message.of(null)).build();
    }

    private Processor createFlowExecutionProcessor(MessageSource messageSource, MessagingExceptionHandler exceptionHandler, MessageProcessContext messageProcessContext, ModuleFlowProcessingPhaseTemplate template) {
        return muleEvent -> {
            try {
                TransactionalErrorHandlingExecutionTemplate transactionTemplate = TransactionalErrorHandlingExecutionTemplate.createMainExecutionTemplate(this.muleContext, messageProcessContext.getFlowConstruct(), messageProcessContext.getTransactionConfig().orElse(new MuleTransactionConfig()), exceptionHandler);
                return transactionTemplate.execute(() -> {
                    this.fireNotification(messageSource, muleEvent, messageProcessContext.getFlowConstruct(), 801);
                    return template.routeEvent(muleEvent);
                });
            }
            catch (MuleException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DefaultMuleException(e);
            }
        };
    }

    private ResponseCompletionCallback createSendFailureResponseCompletationCallback(final PhaseResultNotifier phaseResultNotifier, final ErrorType failureErrorType) {
        return new ResponseCompletionCallback(){

            @Override
            public void responseSentSuccessfully() {
                phaseResultNotifier.phaseSuccessfully();
            }

            @Override
            public Event responseSentWithFailure(MessagingException e, Event event) {
                if (failureErrorType != null) {
                    Event errorEvent = Event.builder(event).error(ErrorBuilder.builder(e.getCause()).errorType(failureErrorType).build()).build();
                    phaseResultNotifier.phaseFailure((Exception)e.getCause());
                    throw new SourceErrorException(errorEvent, failureErrorType, e.getCause());
                }
                LOGGER.error("Unhandled exception processing request", (Throwable)e);
                return event;
            }
        };
    }

    private ResponseCompletionCallback createResponseCompletationCallback(final PhaseResultNotifier phaseResultNotifier) {
        return new ResponseCompletionCallback(){

            @Override
            public void responseSentSuccessfully() {
                phaseResultNotifier.phaseSuccessfully();
            }

            @Override
            public Event responseSentWithFailure(MessagingException e, Event event) {
                if (e.getCause() instanceof SourceErrorException && ModuleFlowProcessingPhase.this.sourceResponseSendErrorType.equals(((SourceErrorException)e.getCause()).getErrorType())) {
                    throw (SourceErrorException)e.getCause();
                }
                throw new SourceErrorException(event, ModuleFlowProcessingPhase.this.sourceResponseSendErrorType, e.getCause());
            }
        };
    }

    private void onTerminate(Consumer<Either<MessagingException, Event>> terminateConsumer, Either<Throwable, Event> result) {
        FunctionalUtils.safely(() -> terminateConsumer.accept(result.mapLeft(throwable -> {
            if (throwable instanceof MessagingException) {
                return (MessagingException)throwable;
            }
            if (throwable instanceof SourceErrorException) {
                return ((SourceErrorException)throwable).toMessagingException();
            }
            return null;
        })));
    }

    @Override
    public int compareTo(MessageProcessPhase messageProcessPhase) {
        if (messageProcessPhase instanceof ValidationPhase) {
            return 1;
        }
        return 0;
    }
}

