/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.management.stats;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.management.stats.ProcessingTime;
import org.mule.runtime.core.management.stats.ProcessingTimeWatcher;

public class DefaultProcessingTimeWatcher
implements ProcessingTimeWatcher,
MuleContextAware {
    private final ReferenceQueue<ProcessingTime> queue = new ReferenceQueue();
    private final Map<ProcessingTimeReference, Object> refs = new ConcurrentHashMap<ProcessingTimeReference, Object>();
    private MuleContext muleContext;
    private Scheduler scheduler;
    private Future<?> checkerTask;

    @Override
    public void addProcessingTime(ProcessingTime processingTime) {
        this.refs.put(new ProcessingTimeReference(processingTime, this.queue), this.refs);
    }

    @Override
    public void start() throws MuleException {
        this.scheduler = this.muleContext.getSchedulerService().customScheduler(this.muleContext.getSchedulerBaseConfig().withName("processing.time.monitor").withMaxConcurrentTasks(1).withShutdownTimeout(0L, TimeUnit.MILLISECONDS));
        this.checkerTask = this.scheduler.submit(new ProcessingTimeChecker());
    }

    @Override
    public void stop() throws MuleException {
        if (this.scheduler != null) {
            this.checkerTask.cancel(true);
            this.scheduler.stop();
        }
        this.refs.clear();
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    static class ProcessingTimeReference
    extends WeakReference<ProcessingTime> {
        private FlowConstructStatistics statistics;
        private AtomicLong accumulator;

        ProcessingTimeReference(ProcessingTime time, ReferenceQueue<ProcessingTime> queue) {
            super(time, queue);
            this.statistics = time.getStatistics();
            this.accumulator = time.getAccumulator();
        }

        public AtomicLong getAccumulator() {
            return this.accumulator;
        }

        public FlowConstructStatistics getStatistics() {
            return this.statistics;
        }
    }

    private class ProcessingTimeChecker
    implements Runnable {
        private ProcessingTimeChecker() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    ProcessingTimeReference ref = (ProcessingTimeReference)DefaultProcessingTimeWatcher.this.queue.remove();
                    DefaultProcessingTimeWatcher.this.refs.remove(ref);
                    FlowConstructStatistics stats = ref.getStatistics();
                    if (!stats.isEnabled()) continue;
                    stats.addCompleteFlowExecutionTime(ref.getAccumulator().longValue());
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

