/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.api.util.ObjectUtils;
import org.mule.runtime.core.processor.AbstractFilteringMessageProcessor;
import org.mule.runtime.core.processor.AbstractMessageProcessorOwner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireTap
extends AbstractMessageProcessorOwner
implements Processor {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected volatile Processor tap;
    protected volatile Filter filter;
    protected Processor filteredTap = new WireTapFilter();

    @Override
    public Event process(Event event) throws MuleException {
        if (this.tap == null) {
            return event;
        }
        try {
            Event tapEvent = Event.builder(event).replyToHandler(null).build();
            Event.setCurrentEvent(tapEvent);
            this.filteredTap.process(tapEvent);
            Event.setCurrentEvent(event);
        }
        catch (MuleException e) {
            this.logger.error("Exception sending to wiretap output " + this.tap, (Throwable)e);
        }
        return event;
    }

    public Processor getTap() {
        return this.tap;
    }

    public void setTap(Processor tap) {
        this.tap = tap;
    }

    @Deprecated
    public void setMessageProcessor(Processor tap) {
        this.setTap(tap);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.tap);
    }

    private class WireTapFilter
    extends AbstractFilteringMessageProcessor {
        private WireTapFilter() {
        }

        @Override
        protected boolean accept(Event event, Event.Builder builder) {
            if (WireTap.this.filter == null) {
                return true;
            }
            return WireTap.this.filter.accept(event, builder);
        }

        @Override
        protected Event processNext(Event event) throws MuleException {
            if (WireTap.this.tap != null) {
                WireTap.this.tap.process(event);
            }
            return null;
        }

        @Override
        public String toString() {
            return ObjectUtils.toString(this);
        }
    }
}

