/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.soap.internal.metadata;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.soap.api.client.metadata.SoapOperationMetadata;

public class SoapOutputTypeBuilder {
    public static final String BODY_FIELD = "body";
    public static final String HEADERS_FIELD = "headers";
    public static final String ATTACHMENTS_FIELD = "attachments";

    public MetadataType build(final SoapOperationMetadata metadata, final BaseTypeBuilder builder) {
        final Reference result = new Reference();
        metadata.getAttachmentsType().accept(new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                ObjectTypeBuilder object = builder.objectType();
                object.addField().key(SoapOutputTypeBuilder.BODY_FIELD).value(metadata.getBodyType());
                object.addField().key(SoapOutputTypeBuilder.ATTACHMENTS_FIELD).value().arrayType().of(builder.anyType());
                result.set(object.build());
            }

            @Override
            public void visitNull(NullType nullType) {
                result.set(metadata.getBodyType());
            }
        });
        return (MetadataType)result.get();
    }

    public MetadataType buildAttributes(SoapOperationMetadata metadata, BaseTypeBuilder builder) {
        MetadataType soapHeadersType = metadata.getHeadersType();
        ObjectTypeBuilder attributes = builder.objectType();
        attributes.addField().key(HEADERS_FIELD).value(soapHeadersType);
        ObjectTypeBuilder protocolHeaders = attributes.addField().key("protocolHeaders").value().objectType();
        protocolHeaders.openWith().stringType();
        return attributes.build();
    }
}

