/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import com.google.common.base.Optional;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.ConstructorResolver;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.support.SimpleAutowireCandidateResolver;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.UsesJava8;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CompositeIterator;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultListableBeanFactory
extends AbstractAutowireCapableBeanFactory
implements ConfigurableListableBeanFactory,
BeanDefinitionRegistry,
Serializable {
    private static Class<?> javaUtilOptionalClass = null;
    private static Class<?> javaxInjectProviderClass = null;
    private static final Map<String, Reference<DefaultListableBeanFactory>> serializableFactories;
    private String serializationId;
    private boolean allowBeanDefinitionOverriding = true;
    private boolean allowEagerClassLoading = true;
    private Comparator<Object> dependencyComparator;
    private AutowireCandidateResolver autowireCandidateResolver = new SimpleAutowireCandidateResolver();
    private final Map<Class<?>, Object> resolvableDependencies = new HashMap(16);
    private final Map<String, BeanDefinition> beanDefinitionMap = new ConcurrentHashMap<String, BeanDefinition>(64);
    private final Map<Class<?>, String[]> allBeanNamesByType = new ConcurrentHashMap(64);
    private final Map<Class<?>, String[]> singletonBeanNamesByType = new ConcurrentHashMap(64);
    private final List<String> beanDefinitionNames = new ArrayList<String>(64);
    private final Set<String> manualSingletonNames = Collections.synchronizedSet(new LinkedHashSet(16));
    private boolean configurationFrozen = false;
    private String[] frozenBeanDefinitionNames;

    public DefaultListableBeanFactory() {
    }

    public DefaultListableBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public void setSerializationId(String serializationId) {
        if (serializationId != null) {
            serializableFactories.put(serializationId, new WeakReference<DefaultListableBeanFactory>(this));
        } else if (this.serializationId != null) {
            serializableFactories.remove(this.serializationId);
        }
        this.serializationId = serializationId;
    }

    public String getSerializationId() {
        return this.serializationId;
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public boolean isAllowBeanDefinitionOverriding() {
        return this.allowBeanDefinitionOverriding;
    }

    public void setAllowEagerClassLoading(boolean allowEagerClassLoading) {
        this.allowEagerClassLoading = allowEagerClassLoading;
    }

    public boolean isAllowEagerClassLoading() {
        return this.allowEagerClassLoading;
    }

    public void setDependencyComparator(Comparator<Object> dependencyComparator) {
        this.dependencyComparator = dependencyComparator;
    }

    public Comparator<Object> getDependencyComparator() {
        return this.dependencyComparator;
    }

    public void setAutowireCandidateResolver(final AutowireCandidateResolver autowireCandidateResolver) {
        Assert.notNull((Object)autowireCandidateResolver, (String)"AutowireCandidateResolver must not be null");
        if (autowireCandidateResolver instanceof BeanFactoryAware) {
            if (System.getSecurityManager() != null) {
                DefaultListableBeanFactory target = this;
                AccessController.doPrivileged(new PrivilegedAction<Object>((BeanFactory)target){
                    final /* synthetic */ BeanFactory val$target;
                    {
                        this.val$target = beanFactory;
                    }

                    @Override
                    public Object run() {
                        ((BeanFactoryAware)autowireCandidateResolver).setBeanFactory(this.val$target);
                        return null;
                    }
                }, this.getAccessControlContext());
            } else {
                ((BeanFactoryAware)autowireCandidateResolver).setBeanFactory((BeanFactory)this);
            }
        }
        this.autowireCandidateResolver = autowireCandidateResolver;
    }

    public AutowireCandidateResolver getAutowireCandidateResolver() {
        return this.autowireCandidateResolver;
    }

    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        super.copyConfigurationFrom(otherFactory);
        if (otherFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory otherListableFactory = (DefaultListableBeanFactory)otherFactory;
            this.allowBeanDefinitionOverriding = otherListableFactory.allowBeanDefinitionOverriding;
            this.allowEagerClassLoading = otherListableFactory.allowEagerClassLoading;
            this.autowireCandidateResolver = otherListableFactory.autowireCandidateResolver;
            this.resolvableDependencies.putAll(otherListableFactory.resolvableDependencies);
        }
    }

    public <T> T getBean(Class<T> requiredType) throws BeansException {
        return this.getBean(requiredType, null);
    }

    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        Assert.notNull(requiredType, (String)"Required type must not be null");
        String[] beanNames = this.getBeanNamesForType(requiredType);
        if (beanNames.length > 1) {
            ArrayList<String> autowireCandidates = new ArrayList<String>();
            for (String beanName : beanNames) {
                if (this.containsBeanDefinition(beanName) && !this.getBeanDefinition(beanName).isAutowireCandidate()) continue;
                autowireCandidates.add(beanName);
            }
            if (autowireCandidates.size() > 0) {
                beanNames = autowireCandidates.toArray(new String[autowireCandidates.size()]);
            }
        }
        if (beanNames.length == 1) {
            return (T)this.getBean(beanNames[0], requiredType, args);
        }
        if (beanNames.length > 1) {
            HashMap<String, Object> candidates = new HashMap<String, Object>();
            for (String beanName : beanNames) {
                candidates.put(beanName, this.getBean(beanName, requiredType, args));
            }
            String primaryCandidate = this.determinePrimaryCandidate(candidates, requiredType);
            if (primaryCandidate != null) {
                return (T)this.getBean(primaryCandidate, requiredType, args);
            }
            String priorityCandidate = this.determineHighestPriorityCandidate(candidates, requiredType);
            if (priorityCandidate != null) {
                return (T)this.getBean(priorityCandidate, requiredType, args);
            }
            throw new NoUniqueBeanDefinitionException(requiredType, candidates.keySet());
        }
        if (this.getParentBeanFactory() != null) {
            return (T)this.getParentBeanFactory().getBean(requiredType, args);
        }
        throw new NoSuchBeanDefinitionException(requiredType);
    }

    public boolean containsBeanDefinition(String beanName) {
        Assert.notNull((Object)beanName, (String)"Bean name must not be null");
        return this.beanDefinitionMap.containsKey(beanName);
    }

    public int getBeanDefinitionCount() {
        return this.beanDefinitionMap.size();
    }

    public String[] getBeanDefinitionNames() {
        if (this.frozenBeanDefinitionNames != null) {
            return this.frozenBeanDefinitionNames;
        }
        return StringUtils.toStringArray(this.beanDefinitionNames);
    }

    public String[] getBeanNamesForType(Class<?> type) {
        return this.getBeanNamesForType(type, true, true);
    }

    public String[] getBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        if (!this.isConfigurationFrozen() || type == null || !allowEagerInit) {
            return this.doGetBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        }
        Map<Class<?>, String[]> cache = includeNonSingletons ? this.allBeanNamesByType : this.singletonBeanNamesByType;
        String[] resolvedBeanNames = cache.get(type);
        if (resolvedBeanNames != null) {
            return resolvedBeanNames;
        }
        resolvedBeanNames = this.doGetBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        if (ClassUtils.isCacheSafe(type, (ClassLoader)this.getBeanClassLoader())) {
            cache.put(type, resolvedBeanNames);
        }
        return resolvedBeanNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] doGetBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        ArrayList<String> result = new ArrayList<String>();
        for (String beanName : this.beanDefinitionNames) {
            if (this.isAlias(beanName)) continue;
            try {
                boolean matchFound;
                RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
                if (mbd.isAbstract() || !allowEagerInit && (!mbd.hasBeanClass() && mbd.isLazyInit() && !this.isAllowEagerClassLoading() || this.requiresEagerInitForType(mbd.getFactoryBeanName()))) continue;
                boolean isFactoryBean = this.isFactoryBean(beanName, mbd);
                boolean bl = matchFound = !(!allowEagerInit && isFactoryBean && !this.containsSingleton(beanName) || !includeNonSingletons && !this.isSingleton(beanName) || !this.isTypeMatch(beanName, type));
                if (!matchFound && isFactoryBean) {
                    beanName = "&" + beanName;
                    boolean bl2 = matchFound = (includeNonSingletons || mbd.isSingleton()) && this.isTypeMatch(beanName, type);
                }
                if (!matchFound) continue;
                result.add(beanName);
            }
            catch (CannotLoadBeanClassException ex) {
                if (allowEagerInit) {
                    throw ex;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring bean class loading failure for bean '" + beanName + "'"), (Throwable)ex);
                }
                this.onSuppressedException((Exception)((Object)ex));
            }
            catch (BeanDefinitionStoreException ex) {
                if (allowEagerInit) {
                    throw ex;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Ignoring unresolvable metadata in bean definition '" + beanName + "'"), (Throwable)ex);
                }
                this.onSuppressedException((Exception)((Object)ex));
            }
        }
        Set<String> set = this.manualSingletonNames;
        synchronized (set) {
            for (String beanName : this.manualSingletonNames) {
                try {
                    if (this.isFactoryBean(beanName)) {
                        if ((includeNonSingletons || this.isSingleton(beanName)) && this.isTypeMatch(beanName, type)) {
                            result.add(beanName);
                            continue;
                        }
                        beanName = "&" + beanName;
                    }
                    if (!this.isTypeMatch(beanName, type)) continue;
                    result.add(beanName);
                }
                catch (NoSuchBeanDefinitionException ex) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Failed to check manually registered singleton with name '" + beanName + "'"), (Throwable)ex);
                }
            }
        }
        return StringUtils.toStringArray(result);
    }

    private boolean requiresEagerInitForType(String factoryBeanName) {
        return factoryBeanName != null && this.isFactoryBean(factoryBeanName) && !this.containsSingleton(factoryBeanName);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        String[] beanNames = this.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(beanNames.length);
        for (String beanName : beanNames) {
            try {
                result.put(beanName, this.getBean(beanName, type));
            }
            catch (BeanCreationException ex) {
                BeanCreationException bce;
                Throwable rootCause = ex.getMostSpecificCause();
                if (rootCause instanceof BeanCurrentlyInCreationException && this.isCurrentlyInCreation((bce = (BeanCreationException)rootCause).getBeanName())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Ignoring match to currently created bean '" + beanName + "': " + ex.getMessage()));
                    }
                    this.onSuppressedException((Exception)((Object)ex));
                    continue;
                }
                throw ex;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        ArrayList<String> results = new ArrayList<String>();
        for (String beanName : this.beanDefinitionNames) {
            BeanDefinition beanDefinition = this.getBeanDefinition(beanName);
            if (beanDefinition.isAbstract() || this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.add(beanName);
        }
        Set<String> set = this.manualSingletonNames;
        synchronized (set) {
            for (String beanName : this.manualSingletonNames) {
                if (results.contains(beanName) || this.findAnnotationOnBean(beanName, annotationType) == null) continue;
                results.add(beanName);
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        String[] beanNames = this.getBeanNamesForAnnotation(annotationType);
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>(beanNames.length);
        for (String beanName : beanNames) {
            results.put(beanName, this.getBean(beanName));
        }
        return results;
    }

    public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        AbstractBeanDefinition abd;
        BeanDefinition bd;
        Annotation ann = null;
        Class beanType = this.getType(beanName);
        if (beanType != null) {
            ann = AnnotationUtils.findAnnotation((Class)beanType, annotationType);
        }
        if (ann == null && this.containsBeanDefinition(beanName) && (bd = this.getMergedBeanDefinition(beanName)) instanceof AbstractBeanDefinition && (abd = (AbstractBeanDefinition)bd).hasBeanClass()) {
            ann = AnnotationUtils.findAnnotation((Class)abd.getBeanClass(), annotationType);
        }
        return (A)ann;
    }

    public void registerResolvableDependency(Class<?> dependencyType, Object autowiredValue) {
        Assert.notNull(dependencyType, (String)"Type must not be null");
        if (autowiredValue != null) {
            Assert.isTrue((autowiredValue instanceof ObjectFactory || dependencyType.isInstance(autowiredValue) ? 1 : 0) != 0, (String)("Value [" + autowiredValue + "] does not implement specified type [" + dependencyType.getName() + "]"));
            this.resolvableDependencies.put(dependencyType, autowiredValue);
        }
    }

    public boolean isAutowireCandidate(String beanName, DependencyDescriptor descriptor) throws NoSuchBeanDefinitionException {
        return this.isAutowireCandidate(beanName, descriptor, this.getAutowireCandidateResolver());
    }

    protected boolean isAutowireCandidate(String beanName, DependencyDescriptor descriptor, AutowireCandidateResolver resolver) throws NoSuchBeanDefinitionException {
        String beanDefinitionName = BeanFactoryUtils.transformedBeanName((String)beanName);
        if (this.containsBeanDefinition(beanDefinitionName)) {
            return this.isAutowireCandidate(beanName, this.getMergedLocalBeanDefinition(beanDefinitionName), descriptor, resolver);
        }
        if (this.containsSingleton(beanName)) {
            return this.isAutowireCandidate(beanName, new RootBeanDefinition(this.getType(beanName)), descriptor, resolver);
        }
        if (this.getParentBeanFactory() instanceof DefaultListableBeanFactory) {
            return ((DefaultListableBeanFactory)this.getParentBeanFactory()).isAutowireCandidate(beanName, descriptor, resolver);
        }
        if (this.getParentBeanFactory() instanceof ConfigurableListableBeanFactory) {
            return ((ConfigurableListableBeanFactory)this.getParentBeanFactory()).isAutowireCandidate(beanName, descriptor);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAutowireCandidate(String beanName, RootBeanDefinition mbd, DependencyDescriptor descriptor, AutowireCandidateResolver resolver) {
        String beanDefinitionName = BeanFactoryUtils.transformedBeanName((String)beanName);
        this.resolveBeanClass(mbd, beanDefinitionName, new Class[0]);
        if (mbd.isFactoryMethodUnique) {
            boolean resolve;
            Object object = mbd.constructorArgumentLock;
            synchronized (object) {
                resolve = mbd.resolvedConstructorOrFactoryMethod == null;
            }
            if (resolve) {
                new ConstructorResolver((AbstractAutowireCapableBeanFactory)this).resolveFactoryMethodIfPossible(mbd);
            }
        }
        return resolver.isAutowireCandidate(new BeanDefinitionHolder((BeanDefinition)mbd, beanName, this.getAliases(beanDefinitionName)), descriptor);
    }

    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        BeanDefinition bd = this.beanDefinitionMap.get(beanName);
        if (bd == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No bean named '" + beanName + "' found in " + this));
            }
            throw new NoSuchBeanDefinitionException(beanName);
        }
        return bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getBeanNamesIterator() {
        CompositeIterator iterator = new CompositeIterator();
        iterator.add(this.beanDefinitionNames.iterator());
        Set<String> set = this.manualSingletonNames;
        synchronized (set) {
            iterator.add(new ArrayList<String>(this.manualSingletonNames).iterator());
        }
        return iterator;
    }

    public void freezeConfiguration() {
        this.configurationFrozen = true;
        this.frozenBeanDefinitionNames = StringUtils.toStringArray(this.beanDefinitionNames);
    }

    public boolean isConfigurationFrozen() {
        return this.configurationFrozen;
    }

    protected boolean isBeanEligibleForMetadataCaching(String beanName) {
        return this.configurationFrozen || super.isBeanEligibleForMetadataCaching(beanName);
    }

    public void preInstantiateSingletons() throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Pre-instantiating singletons in " + this));
        }
        ArrayList<String> beanNames = new ArrayList<String>(this.beanDefinitionNames);
        for (String beanName : beanNames) {
            RootBeanDefinition bd = this.getMergedLocalBeanDefinition(beanName);
            if (bd.isAbstract() || !bd.isSingleton() || bd.isLazyInit()) continue;
            if (this.isFactoryBean(beanName)) {
                boolean isEagerInit;
                final FactoryBean factory = (FactoryBean)this.getBean("&" + beanName);
                if (System.getSecurityManager() != null && factory instanceof SmartFactoryBean) {
                    isEagerInit = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            return ((SmartFactoryBean)factory).isEagerInit();
                        }
                    }, this.getAccessControlContext());
                } else {
                    boolean bl = isEagerInit = factory instanceof SmartFactoryBean && ((SmartFactoryBean)factory).isEagerInit();
                }
                if (!isEagerInit) continue;
                this.getBean(beanName);
                continue;
            }
            this.getBean(beanName);
        }
        for (String beanName : beanNames) {
            Object singletonInstance = this.getSingleton(beanName);
            if (!(singletonInstance instanceof SmartInitializingSingleton)) continue;
            final SmartInitializingSingleton smartSingleton = (SmartInitializingSingleton)singletonInstance;
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        smartSingleton.afterSingletonsInstantiated();
                        return null;
                    }
                }, this.getAccessControlContext());
                continue;
            }
            smartSingleton.afterSingletonsInstantiated();
        }
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        BeanDefinition oldBeanDefinition;
        Assert.hasText((String)beanName, (String)"Bean name must not be empty");
        Assert.notNull((Object)beanDefinition, (String)"BeanDefinition must not be null");
        if (beanDefinition instanceof AbstractBeanDefinition) {
            try {
                ((AbstractBeanDefinition)beanDefinition).validate();
            }
            catch (BeanDefinitionValidationException ex) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Validation of bean definition failed", (Throwable)ex);
            }
        }
        if ((oldBeanDefinition = this.beanDefinitionMap.get(beanName)) != null) {
            if (!this.isAllowBeanDefinitionOverriding()) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), beanName, "Cannot register bean definition [" + beanDefinition + "] for bean '" + beanName + "': There is already [" + oldBeanDefinition + "] bound.");
            }
            if (oldBeanDefinition.getRole() < beanDefinition.getRole()) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("Overriding user-defined bean definition for bean '" + beanName + "' with a framework-generated bean definition: replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]"));
                }
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Overriding bean definition for bean '" + beanName + "': replacing [" + oldBeanDefinition + "] with [" + beanDefinition + "]"));
            }
        } else {
            this.beanDefinitionNames.add(beanName);
            this.manualSingletonNames.remove(beanName);
            this.frozenBeanDefinitionNames = null;
        }
        this.beanDefinitionMap.put(beanName, beanDefinition);
        if (oldBeanDefinition != null || this.containsSingleton(beanName)) {
            this.resetBeanDefinition(beanName);
        }
    }

    public void removeBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        Assert.hasText((String)beanName, (String)"'beanName' must not be empty");
        BeanDefinition bd = this.beanDefinitionMap.remove(beanName);
        if (bd == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No bean named '" + beanName + "' found in " + this));
            }
            throw new NoSuchBeanDefinitionException(beanName);
        }
        this.beanDefinitionNames.remove(beanName);
        this.frozenBeanDefinitionNames = null;
        this.resetBeanDefinition(beanName);
    }

    protected void resetBeanDefinition(String beanName) {
        this.clearMergedBeanDefinition(beanName);
        this.destroySingleton(beanName);
        for (String bdName : this.beanDefinitionNames) {
            BeanDefinition bd;
            if (beanName.equals(bdName) || !beanName.equals((bd = this.beanDefinitionMap.get(bdName)).getParentName())) continue;
            this.resetBeanDefinition(bdName);
        }
    }

    protected boolean allowAliasOverriding() {
        return this.isAllowBeanDefinitionOverriding();
    }

    public void registerSingleton(String beanName, Object singletonObject) throws IllegalStateException {
        super.registerSingleton(beanName, singletonObject);
        if (!this.beanDefinitionMap.containsKey(beanName)) {
            this.manualSingletonNames.add(beanName);
        }
        this.clearByTypeCache();
    }

    public void destroySingleton(String beanName) {
        super.destroySingleton(beanName);
        this.manualSingletonNames.remove(beanName);
        this.clearByTypeCache();
    }

    public void destroySingletons() {
        super.destroySingletons();
        this.manualSingletonNames.clear();
        this.clearByTypeCache();
    }

    private void clearByTypeCache() {
        this.allBeanNamesByType.clear();
        this.singletonBeanNamesByType.clear();
    }

    public Object resolveDependency(DependencyDescriptor descriptor, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) throws BeansException {
        descriptor.initParameterNameDiscovery(this.getParameterNameDiscoverer());
        if (descriptor.getDependencyType().equals(javaUtilOptionalClass)) {
            return new OptionalDependencyFactory().createOptionalDependency(descriptor, beanName);
        }
        if (descriptor.getDependencyType().equals(ObjectFactory.class)) {
            return new DependencyObjectFactory(descriptor, beanName);
        }
        if (descriptor.getDependencyType().equals(javaxInjectProviderClass)) {
            return new DependencyProviderFactory().createDependencyProvider(descriptor, beanName);
        }
        Object result = this.getAutowireCandidateResolver().getLazyResolutionProxyIfNecessary(descriptor, beanName);
        if (result == null) {
            result = this.doResolveDependency(descriptor, beanName, autowiredBeanNames, typeConverter);
        }
        return result;
    }

    public Object doResolveDependency(DependencyDescriptor descriptor, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) throws BeansException {
        Class type = descriptor.getDependencyType();
        Object value = this.getAutowireCandidateResolver().getSuggestedValue(descriptor);
        if (value != null) {
            if (value instanceof String) {
                String strVal = this.resolveEmbeddedValue((String)value);
                BeanDefinition bd = beanName != null && this.containsBean(beanName) ? this.getMergedBeanDefinition(beanName) : null;
                value = this.evaluateBeanDefinitionString(strVal, bd);
            }
            TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
            return descriptor.getField() != null ? converter.convertIfNecessary(value, type, descriptor.getField()) : converter.convertIfNecessary(value, type, descriptor.getMethodParameter());
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            DependencyDescriptor targetDesc = new DependencyDescriptor(descriptor);
            targetDesc.increaseNestingLevel();
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, componentType, targetDesc);
            if (matchingBeans.isEmpty()) {
                if (descriptor.isRequired()) {
                    this.raiseNoSuchBeanDefinitionException(componentType, "array of " + componentType.getName(), descriptor);
                }
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
            TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
            Object result = converter.convertIfNecessary(matchingBeans.values(), type);
            if (this.getDependencyComparator() != null && result instanceof Object[]) {
                Arrays.sort((Object[])result, this.adaptDependencyComparator(matchingBeans));
            }
            return result;
        }
        if (Collection.class.isAssignableFrom(type) && type.isInterface()) {
            Class elementType = descriptor.getCollectionType();
            if (elementType == null) {
                if (descriptor.isRequired()) {
                    throw new FatalBeanException("No element type declared for collection [" + type.getName() + "]");
                }
                return null;
            }
            DependencyDescriptor targetDesc = new DependencyDescriptor(descriptor);
            targetDesc.increaseNestingLevel();
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, elementType, targetDesc);
            if (matchingBeans.isEmpty()) {
                if (descriptor.isRequired()) {
                    this.raiseNoSuchBeanDefinitionException(elementType, "collection of " + elementType.getName(), descriptor);
                }
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
            TypeConverter converter = typeConverter != null ? typeConverter : this.getTypeConverter();
            Object result = converter.convertIfNecessary(matchingBeans.values(), type);
            if (this.getDependencyComparator() != null && result instanceof List) {
                Collections.sort((List)result, this.adaptDependencyComparator(matchingBeans));
            }
            return result;
        }
        if (Map.class.isAssignableFrom(type) && type.isInterface()) {
            Class keyType = descriptor.getMapKeyType();
            if (keyType == null || !String.class.isAssignableFrom(keyType)) {
                if (descriptor.isRequired()) {
                    throw new FatalBeanException("Key type [" + keyType + "] of map [" + type.getName() + "] must be assignable to [java.lang.String]");
                }
                return null;
            }
            Class valueType = descriptor.getMapValueType();
            if (valueType == null) {
                if (descriptor.isRequired()) {
                    throw new FatalBeanException("No value type declared for map [" + type.getName() + "]");
                }
                return null;
            }
            DependencyDescriptor targetDesc = new DependencyDescriptor(descriptor);
            targetDesc.increaseNestingLevel();
            Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, valueType, targetDesc);
            if (matchingBeans.isEmpty()) {
                if (descriptor.isRequired()) {
                    this.raiseNoSuchBeanDefinitionException(valueType, "map with value type " + valueType.getName(), descriptor);
                }
                return null;
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.addAll(matchingBeans.keySet());
            }
            return matchingBeans;
        }
        Map<String, Object> matchingBeans = this.findAutowireCandidates(beanName, type, descriptor);
        if (matchingBeans.isEmpty()) {
            if (descriptor.isRequired()) {
                this.raiseNoSuchBeanDefinitionException(type, "", descriptor);
            }
            return null;
        }
        if (matchingBeans.size() > 1) {
            String primaryBeanName = this.determineAutowireCandidate(matchingBeans, descriptor);
            if (primaryBeanName == null) {
                throw new NoUniqueBeanDefinitionException(type, matchingBeans.keySet());
            }
            if (autowiredBeanNames != null) {
                autowiredBeanNames.add(primaryBeanName);
            }
            return matchingBeans.get(primaryBeanName);
        }
        Map.Entry<String, Object> entry = matchingBeans.entrySet().iterator().next();
        if (autowiredBeanNames != null) {
            autowiredBeanNames.add(entry.getKey());
        }
        return entry.getValue();
    }

    private Comparator<Object> adaptDependencyComparator(Map<String, Object> matchingBeans) {
        Comparator<Object> comparator = this.getDependencyComparator();
        if (comparator instanceof OrderComparator) {
            return ((OrderComparator)comparator).withSourceProvider((OrderComparator.OrderSourceProvider)this.createFactoryAwareOrderSourceProvider(matchingBeans));
        }
        return comparator;
    }

    private FactoryAwareOrderSourceProvider createFactoryAwareOrderSourceProvider(Map<String, Object> beans) {
        IdentityHashMap<Object, String> instancesToBeanNames = new IdentityHashMap<Object, String>();
        for (Map.Entry<String, Object> entry : beans.entrySet()) {
            instancesToBeanNames.put(entry.getValue(), entry.getKey());
        }
        return new FactoryAwareOrderSourceProvider(instancesToBeanNames);
    }

    protected Map<String, Object> findAutowireCandidates(String beanName, Class<?> requiredType, DependencyDescriptor descriptor) {
        String[] candidateNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this, requiredType, (boolean)true, (boolean)descriptor.isEager());
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(candidateNames.length);
        for (Class<?> autowiringType : this.resolvableDependencies.keySet()) {
            if (!autowiringType.isAssignableFrom(requiredType)) continue;
            Object autowiringValue = this.resolvableDependencies.get(autowiringType);
            if (!requiredType.isInstance(autowiringValue = AutowireUtils.resolveAutowiringValue((Object)autowiringValue, requiredType))) continue;
            result.put(ObjectUtils.identityToString((Object)autowiringValue), autowiringValue);
            break;
        }
        for (String candidateName : candidateNames) {
            if (this.isSelfReference(beanName, candidateName) || !this.isAutowireCandidate(candidateName, descriptor)) continue;
            result.put(candidateName, this.getBean(candidateName));
        }
        if (result.isEmpty()) {
            DependencyDescriptor fallbackDescriptor = descriptor.forFallbackMatch();
            for (String candidateName : candidateNames) {
                if (candidateName.equals(beanName) || !this.isAutowireCandidate(candidateName, fallbackDescriptor)) continue;
                result.put(candidateName, this.getBean(candidateName));
            }
        }
        return result;
    }

    protected String determineAutowireCandidate(Map<String, Object> candidateBeans, DependencyDescriptor descriptor) {
        Class requiredType = descriptor.getDependencyType();
        String primaryCandidate = this.determinePrimaryCandidate(candidateBeans, requiredType);
        if (primaryCandidate != null) {
            return primaryCandidate;
        }
        String priorityCandidate = this.determineHighestPriorityCandidate(candidateBeans, requiredType);
        if (priorityCandidate != null) {
            return priorityCandidate;
        }
        for (Map.Entry<String, Object> entry : candidateBeans.entrySet()) {
            String candidateBeanName = entry.getKey();
            Object beanInstance = entry.getValue();
            if (!this.resolvableDependencies.values().contains(beanInstance) && !this.matchesBeanName(candidateBeanName, descriptor.getDependencyName())) continue;
            return candidateBeanName;
        }
        return null;
    }

    protected String determinePrimaryCandidate(Map<String, Object> candidateBeans, Class<?> requiredType) {
        String primaryBeanName = null;
        for (Map.Entry<String, Object> entry : candidateBeans.entrySet()) {
            Object beanInstance;
            String candidateBeanName = entry.getKey();
            if (!this.isPrimary(candidateBeanName, beanInstance = entry.getValue())) continue;
            if (primaryBeanName != null) {
                boolean candidateLocal = this.containsBeanDefinition(candidateBeanName);
                boolean primaryLocal = this.containsBeanDefinition(primaryBeanName);
                if (candidateLocal && primaryLocal) {
                    throw new NoUniqueBeanDefinitionException(requiredType, candidateBeans.size(), "more than one 'primary' bean found among candidates: " + candidateBeans.keySet());
                }
                if (!candidateLocal) continue;
                primaryBeanName = candidateBeanName;
                continue;
            }
            primaryBeanName = candidateBeanName;
        }
        return primaryBeanName;
    }

    protected String determineHighestPriorityCandidate(Map<String, Object> candidateBeans, Class<?> requiredType) {
        String highestPriorityBeanName = null;
        Integer highestPriority = null;
        for (Map.Entry<String, Object> entry : candidateBeans.entrySet()) {
            String candidateBeanName = entry.getKey();
            Object beanInstance = entry.getValue();
            Integer candidatePriority = this.getPriority(beanInstance);
            if (candidatePriority == null) continue;
            if (highestPriorityBeanName != null) {
                if (candidatePriority.equals(highestPriority)) {
                    throw new NoUniqueBeanDefinitionException(requiredType, candidateBeans.size(), "Multiple beans found with the same priority ('" + highestPriority + "') among candidates: " + candidateBeans.keySet());
                }
                if (candidatePriority >= highestPriority) continue;
                highestPriorityBeanName = candidateBeanName;
                highestPriority = candidatePriority;
                continue;
            }
            highestPriorityBeanName = candidateBeanName;
            highestPriority = candidatePriority;
        }
        return highestPriorityBeanName;
    }

    protected boolean isPrimary(String beanName, Object beanInstance) {
        if (this.containsBeanDefinition(beanName)) {
            return this.getMergedLocalBeanDefinition(beanName).isPrimary();
        }
        BeanFactory parentFactory = this.getParentBeanFactory();
        return parentFactory instanceof DefaultListableBeanFactory && ((DefaultListableBeanFactory)parentFactory).isPrimary(beanName, beanInstance);
    }

    protected Integer getPriority(Object beanInstance) {
        Comparator<Object> comparator = this.getDependencyComparator();
        if (comparator instanceof OrderComparator) {
            return ((OrderComparator)comparator).getPriority(beanInstance);
        }
        return null;
    }

    protected boolean matchesBeanName(String beanName, String candidateName) {
        return candidateName != null && (candidateName.equals(beanName) || ObjectUtils.containsElement((Object[])this.getAliases(beanName), (Object)candidateName));
    }

    private boolean isSelfReference(String beanName, String candidateName) {
        return beanName != null && candidateName != null && (beanName.equals(candidateName) || this.containsBeanDefinition(candidateName) && beanName.equals(this.getMergedLocalBeanDefinition(candidateName).getFactoryBeanName()));
    }

    private void raiseNoSuchBeanDefinitionException(Class<?> type, String dependencyDescription, DependencyDescriptor descriptor) throws NoSuchBeanDefinitionException {
        throw new NoSuchBeanDefinitionException(type, dependencyDescription, "expected at least 1 bean which qualifies as autowire candidate for this dependency. Dependency annotations: " + ObjectUtils.nullSafeToString((Object[])descriptor.getAnnotations()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ObjectUtils.identityToString((Object)this));
        sb.append(": defining beans [");
        sb.append(StringUtils.collectionToCommaDelimitedString(this.beanDefinitionNames));
        sb.append("]; ");
        BeanFactory parent = this.getParentBeanFactory();
        if (parent == null) {
            sb.append("root of factory hierarchy");
        } else {
            sb.append("parent: ").append(ObjectUtils.identityToString((Object)parent));
        }
        return sb.toString();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        throw new NotSerializableException("DefaultListableBeanFactory itself is not deserializable - just a SerializedBeanFactoryReference is");
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.serializationId != null) {
            return new SerializedBeanFactoryReference(this.serializationId);
        }
        throw new NotSerializableException("DefaultListableBeanFactory has no serialization id");
    }

    static {
        try {
            javaUtilOptionalClass = ClassUtils.forName((String)"java.util.Optional", (ClassLoader)DefaultListableBeanFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            javaxInjectProviderClass = ClassUtils.forName((String)"javax.inject.Provider", (ClassLoader)DefaultListableBeanFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        serializableFactories = new ConcurrentHashMap<String, Reference<DefaultListableBeanFactory>>(8);
    }

    private class FactoryAwareOrderSourceProvider
    implements OrderComparator.OrderSourceProvider {
        private final Map<Object, String> instancesToBeanNames;

        public FactoryAwareOrderSourceProvider(Map<Object, String> instancesToBeanNames) {
            this.instancesToBeanNames = instancesToBeanNames;
        }

        public Object getOrderSource(Object obj) {
            return this.getFactoryMethod(this.instancesToBeanNames.get(obj));
        }

        private Method getFactoryMethod(String beanName) {
            BeanDefinition bd;
            if (beanName != null && DefaultListableBeanFactory.this.containsBeanDefinition(beanName) && (bd = DefaultListableBeanFactory.this.getMergedBeanDefinition(beanName)) instanceof RootBeanDefinition) {
                return ((RootBeanDefinition)bd).getResolvedFactoryMethod();
            }
            return null;
        }
    }

    private class DependencyProviderFactory {
        private DependencyProviderFactory() {
        }

        public Object createDependencyProvider(DependencyDescriptor descriptor, String beanName) {
            return new DependencyProvider(descriptor, beanName);
        }
    }

    private class DependencyProvider
    extends DependencyObjectFactory
    implements Provider<Object> {
        public DependencyProvider(DependencyDescriptor descriptor, String beanName) {
            super(descriptor, beanName);
        }

        public Object get() throws BeansException {
            return this.getObject();
        }
    }

    private class DependencyObjectFactory
    implements ObjectFactory<Object>,
    Serializable {
        private final DependencyDescriptor descriptor;
        private final boolean optional;
        private final String beanName;

        public DependencyObjectFactory(DependencyDescriptor descriptor, String beanName) {
            this.descriptor = new DependencyDescriptor(descriptor);
            this.descriptor.increaseNestingLevel();
            this.optional = this.descriptor.getDependencyType().equals(javaUtilOptionalClass);
            this.beanName = beanName;
        }

        public Object getObject() throws BeansException {
            if (this.optional) {
                return new OptionalDependencyFactory().createOptionalDependency(this.descriptor, this.beanName);
            }
            return DefaultListableBeanFactory.this.doResolveDependency(this.descriptor, this.beanName, null, null);
        }
    }

    @UsesJava8
    private class OptionalDependencyFactory {
        private OptionalDependencyFactory() {
        }

        public Object createOptionalDependency(DependencyDescriptor descriptor, String beanName) {
            DependencyDescriptor descriptorToUse = new DependencyDescriptor(descriptor){

                public boolean isRequired() {
                    return false;
                }
            };
            descriptorToUse.increaseNestingLevel();
            return Optional.fromNullable((Object)DefaultListableBeanFactory.this.doResolveDependency(descriptorToUse, beanName, null, null));
        }
    }

    private static class SerializedBeanFactoryReference
    implements Serializable {
        private final String id;

        public SerializedBeanFactoryReference(String id) {
            this.id = id;
        }

        private Object readResolve() {
            Reference ref = (Reference)serializableFactories.get(this.id);
            if (ref == null) {
                throw new IllegalStateException("Cannot deserialize BeanFactory with id " + this.id + ": no factory registered for this id");
            }
            Object result = ref.get();
            if (result == null) {
                throw new IllegalStateException("Cannot deserialize BeanFactory with id " + this.id + ": factory has been garbage-collected");
            }
            return result;
        }
    }
}

