/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.internal.transformer.simple.ObjectToByteArray;
import org.mule.runtime.core.processor.AbstractRedeliveryPolicy;
import org.mule.runtime.core.transformer.simple.ByteArrayToHexString;
import org.mule.runtime.core.util.store.ObjectStorePartition;
import org.mule.runtime.core.util.store.ProvidedObjectStoreWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdempotentRedeliveryPolicy
extends AbstractRedeliveryPolicy {
    private final ObjectToByteArray objectToByteArray = new ObjectToByteArray();
    private final ByteArrayToHexString byteArrayToHexString = new ByteArrayToHexString();
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean useSecureHash;
    private String messageDigestAlgorithm;
    private String idExpression;
    private ObjectStore<AtomicInteger> store;
    private LockFactory lockFactory;
    private String idrId;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.useSecureHash && this.idExpression != null) {
            this.useSecureHash = false;
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Disabling useSecureHash in idempotent-redelivery-policy since an idExpression has been configured");
            }
        }
        if (!this.useSecureHash && this.messageDigestAlgorithm != null) {
            throw new InitialisationException(CoreMessages.initialisationFailure(String.format("The message digest algorithm '%s' was specified when a secure hash will not be used", this.messageDigestAlgorithm)), (Initialisable)this);
        }
        if (!this.useSecureHash && this.idExpression == null) {
            throw new InitialisationException(CoreMessages.initialisationFailure("No method for identifying messages was specified"), (Initialisable)this);
        }
        if (this.useSecureHash) {
            if (this.messageDigestAlgorithm == null) {
                this.messageDigestAlgorithm = "SHA-256";
            }
            try {
                MessageDigest.getInstance(this.messageDigestAlgorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new InitialisationException(CoreMessages.initialisationFailure(String.format("Exception '%s' initializing message digest algorithm %s", e.getMessage(), this.messageDigestAlgorithm)), (Initialisable)this);
            }
        }
        String appName = this.muleContext.getConfiguration().getId();
        String flowName = this.flowConstruct.getName();
        this.idrId = String.format("%s-%s-%s", appName, flowName, "idr");
        this.lockFactory = this.muleContext.getLockFactory();
        if (this.store == null) {
            this.store = new ProvidedObjectStoreWrapper<AtomicInteger>(null, this.internalObjectStoreSupplier());
        }
        LifecycleUtils.initialiseIfNeeded(this.objectToByteArray, this.muleContext);
        LifecycleUtils.initialiseIfNeeded(this.byteArrayToHexString, this.muleContext);
    }

    private Supplier<ObjectStore> internalObjectStoreSupplier() {
        return () -> {
            ObjectStoreManager objectStoreManager = this.muleContext.getObjectStoreManager();
            return objectStoreManager.getObjectStore(this.flowConstruct.getName() + "." + this.getClass().getName(), false, -1, 300000L, 6000L);
        };
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.store != null) {
            if (this.store instanceof ObjectStorePartition) {
                try {
                    ((ObjectStorePartition)this.store).close();
                }
                catch (ObjectStoreException e) {
                    this.logger.warn("error closing object store: " + e.getMessage(), (Throwable)e);
                }
            }
            this.store = null;
        }
    }

    @Override
    public void start() throws MuleException {
    }

    /*
     * Exception decompiling
     */
    @Override
    public Event process(Event event) throws MuleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void resetCounter(String messageId) throws ObjectStoreException {
        this.store.remove((Serializable)((Object)messageId));
        this.store.store((Serializable)((Object)messageId), new AtomicInteger());
    }

    public AtomicInteger findCounter(String messageId) throws ObjectStoreException {
        boolean counterExists = this.store.contains((Serializable)((Object)messageId));
        if (counterExists) {
            return this.store.retrieve((Serializable)((Object)messageId));
        }
        return null;
    }

    private AtomicInteger incrementCounter(String messageId) throws ObjectStoreException {
        AtomicInteger counter = this.findCounter(messageId);
        if (counter == null) {
            counter = new AtomicInteger();
        } else {
            this.store.remove((Serializable)((Object)messageId));
        }
        counter.incrementAndGet();
        this.store.store((Serializable)((Object)messageId), counter);
        return counter;
    }

    private String getIdForEvent(Event event) throws Exception {
        if (this.useSecureHash) {
            Object payload = event.getMessage().getPayload().getValue();
            byte[] bytes = (byte[])this.objectToByteArray.transform(payload);
            if (payload instanceof InputStream) {
                event = Event.builder(event).message(Message.builder(event.getMessage()).payload(bytes).build()).build();
            }
            MessageDigest md = MessageDigest.getInstance(this.messageDigestAlgorithm);
            byte[] digestedBytes = md.digest(bytes);
            return (String)this.byteArrayToHexString.transform(digestedBytes);
        }
        return this.muleContext.getExpressionManager().parse(this.idExpression, event, this.flowConstruct);
    }

    public boolean isUseSecureHash() {
        return this.useSecureHash;
    }

    public void setUseSecureHash(boolean useSecureHash) {
        this.useSecureHash = useSecureHash;
    }

    public String getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public void setMessageDigestAlgorithm(String messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(String idExpression) {
        this.idExpression = idExpression;
    }

    public void setObjectStore(ObjectStore<AtomicInteger> store) {
        this.store = new ProvidedObjectStoreWrapper<AtomicInteger>(store, this.internalObjectStoreSupplier());
    }
}

