/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.util.message;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.streaming.CursorProviderFactory;
import org.mule.runtime.core.util.message.MessageUtils;
import org.mule.runtime.core.util.message.ResultToMessageIterator;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class ResultsToMessageCollection
implements Collection<Message> {
    private final Collection<Result> delegate;
    protected final CursorProviderFactory cursorProviderFactory;
    protected final Event event;

    public ResultsToMessageCollection(Collection<Result> delegate, CursorProviderFactory cursorProviderFactory, Event event) {
        this.delegate = delegate;
        this.cursorProviderFactory = cursorProviderFactory;
        this.event = event;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<Message> iterator() {
        Iterator<Result> iterator = this.delegate.iterator();
        return new ResultToMessageIterator(iterator, this.cursorProviderFactory, this.event);
    }

    @Override
    public Object[] toArray() {
        return this.transformArray(this.delegate.toArray());
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.transformArray(this.delegate.toArray(a));
    }

    private <T> T[] transformArray(T[] array) {
        return Stream.of(array).map(result -> MessageUtils.toMessage((Result)result, this.cursorProviderFactory, this.event)).toArray(Object[]::new);
    }

    @Override
    public boolean add(Message message) {
        return this.delegate.add(Result.builder(message).build());
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(this.toResults(c));
    }

    protected Collection<Result> toResults(Collection<? extends Message> messages) {
        return messages.stream().map(message -> Result.builder(message).build()).collect(Collectors.toList());
    }

    @Override
    public boolean addAll(Collection<? extends Message> c) {
        return this.delegate.addAll(this.toResults(c));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(this.toResults(c));
    }

    @Override
    public boolean removeIf(Predicate<? super Message> filter) {
        return this.delegate.removeIf((? super E result) -> filter.test(MessageUtils.toMessage(result)));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(this.toResults(c));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Spliterator<Message> spliterator() {
        return this.delegate.stream().map(result -> MessageUtils.toMessage(result, this.cursorProviderFactory, this.event)).collect(Collectors.toList()).spliterator();
    }

    @Override
    public Stream<Message> stream() {
        return this.delegate.stream().map(result -> MessageUtils.toMessage(result, this.cursorProviderFactory, this.event));
    }

    @Override
    public Stream<Message> parallelStream() {
        return this.delegate.parallelStream().map(result -> MessageUtils.toMessage(result, this.cursorProviderFactory, this.event));
    }

    @Override
    public void forEach(Consumer<? super Message> action) {
        this.stream().forEach(action);
    }
}

