/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginRepository;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorFactory;

public class DefaultArtifactPluginRepository
implements ArtifactPluginRepository {
    private volatile List<ArtifactPluginDescriptor> containerArtifactPluginDescriptors;
    private final ArtifactPluginDescriptorFactory pluginDescriptorFactory;

    public DefaultArtifactPluginRepository(ArtifactPluginDescriptorFactory pluginDescriptorFactory) {
        Preconditions.checkArgument(pluginDescriptorFactory != null, "Application plugin descriptor factory cannot be null");
        this.pluginDescriptorFactory = pluginDescriptorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ArtifactPluginDescriptor> getContainerArtifactPluginDescriptors() {
        if (this.containerArtifactPluginDescriptors == null) {
            DefaultArtifactPluginRepository defaultArtifactPluginRepository = this;
            synchronized (defaultArtifactPluginRepository) {
                if (this.containerArtifactPluginDescriptors == null) {
                    try {
                        this.containerArtifactPluginDescriptors = Collections.unmodifiableList(this.collectContainerApplicationPluginDescriptors());
                    }
                    catch (IOException e) {
                        throw new ArtifactDescriptorCreateException("Cannot load application plugin descriptors from container", e);
                    }
                }
            }
        }
        return this.containerArtifactPluginDescriptors;
    }

    private List<ArtifactPluginDescriptor> collectContainerApplicationPluginDescriptors() throws IOException {
        File[] containerPlugins = MuleFoldersUtil.getContainerAppPluginsFolder().listFiles();
        if (containerPlugins != null) {
            return this.createApplicationPluginDescriptors();
        }
        return Collections.EMPTY_LIST;
    }

    private List<ArtifactPluginDescriptor> createApplicationPluginDescriptors() {
        LinkedList<ArtifactPluginDescriptor> pluginDescriptors = new LinkedList<ArtifactPluginDescriptor>();
        for (File plguinJarFile : MuleFoldersUtil.getContainerAppPluginsFolder().listFiles()) {
            ArtifactPluginDescriptor appPluginDescriptor = this.pluginDescriptorFactory.create(plguinJarFile);
            pluginDescriptors.add(appPluginDescriptor);
        }
        return pluginDescriptors;
    }
}

