/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.enricher.BooleanParameterDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ClassLoaderDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ConfigNameDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ConnectionDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.DataTypeDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.DisplayDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.DynamicMetadataDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ErrorsDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ExtensionDescriptionsEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ExtensionsErrorsDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ImportedTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaConfigurationDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaExportedTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaOAuthDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaXmlDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ParameterLayoutOrderDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.SubTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.ModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.validation.ConfigurationModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ConnectionProviderModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ExportedTypesModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.JavaSubtypesModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.MetadataComponentModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.NullSafeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.OAuthConnectionProviderModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.OperationParametersTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.OperationReturnTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ParameterGroupModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ParameterTypeModelValidator;

public class AbstractJavaExtensionModelLoader
extends ExtensionModelLoader {
    public static final String TYPE_PROPERTY_NAME = "type";
    public static final String VERSION = "version";
    private final List<ExtensionModelValidator> customValidators = Collections.unmodifiableList(Arrays.asList(new ConfigurationModelValidator(), new ConnectionProviderModelValidator(), new ExportedTypesModelValidator(), new JavaSubtypesModelValidator(), new MetadataComponentModelValidator(), new NullSafeModelValidator(), new OperationReturnTypeModelValidator(), new OperationParametersTypeModelValidator(), new ParameterGroupModelValidator(), new ParameterTypeModelValidator(), new OAuthConnectionProviderModelValidator()));
    private final List<DeclarationEnricher> customDeclarationEnrichers = Collections.unmodifiableList(Arrays.asList(new ClassLoaderDeclarationEnricher(), new JavaXmlDeclarationEnricher(), new BooleanParameterDeclarationEnricher(), new ConfigNameDeclarationEnricher(), new ConnectionDeclarationEnricher(), new ErrorsDeclarationEnricher(), new ExtensionsErrorsDeclarationEnricher(), new DataTypeDeclarationEnricher(), new DisplayDeclarationEnricher(), new DynamicMetadataDeclarationEnricher(), new ImportedTypesDeclarationEnricher(), new JavaConfigurationDeclarationEnricher(), new JavaExportedTypesDeclarationEnricher(), new JavaOAuthDeclarationEnricher(), new SubTypesDeclarationEnricher(), new ExtensionDescriptionsEnricher(), new ParameterLayoutOrderDeclarationEnricher()));
    private final String id;
    private final BiFunction<Class<?>, String, ModelLoaderDelegate> delegateFactory;

    public AbstractJavaExtensionModelLoader(String id, BiFunction<Class<?>, String, ModelLoaderDelegate> delegate) {
        this.id = id;
        this.delegateFactory = delegate;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    protected void configureContextBeforeDeclaration(ExtensionLoadingContext context) {
        context.addCustomValidators(this.customValidators);
        context.addCustomDeclarationEnrichers(this.customDeclarationEnrichers);
    }

    @Override
    protected void declareExtension(ExtensionLoadingContext context) {
        Class<?> extensionType = this.getExtensionType(context);
        String version = (String)context.getParameter(VERSION).orElseThrow(() -> new IllegalArgumentException("version not specified"));
        this.delegateFactory.apply(extensionType, version).declare(context);
    }

    private Class<?> getExtensionType(ExtensionLoadingContext context) {
        String type = (String)context.getParameter(TYPE_PROPERTY_NAME).get();
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new IllegalArgumentException(String.format("Property '%s' has not been specified", TYPE_PROPERTY_NAME));
        }
        try {
            return ClassUtils.loadClass(type, context.getExtensionClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("Class '%s' cannot be loaded", type), e);
        }
    }
}

