/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.metadata;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.message.MessageMetadataTypeBuilder;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.extension.api.metadata.MetadataResolverUtils;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.metadata.BaseMetadataDelegate;

class MetadataOutputDelegate
extends BaseMetadataDelegate {
    MetadataOutputDelegate(ComponentModel componentModel) {
        super(componentModel);
    }

    Optional<String> getCategoryName() {
        return MetadataResolverUtils.getCategoryName(this.resolverFactory);
    }

    MetadataResult<OutputMetadataDescriptor> getOutputMetadataDescriptor(MetadataContext context, Object key) {
        MetadataResult<MetadataType> output = this.getOutputMetadata(context, key);
        MetadataResult<MetadataType> attributes = this.getOutputAttributesMetadata(context, key);
        MetadataResult<TypeMetadataDescriptor> outputDescriptor = this.toMetadataDescriptorResult(this.component.getOutput().getType(), this.component.getOutput().hasDynamicType(), output);
        MetadataResult<TypeMetadataDescriptor> attributesDescriptor = this.toMetadataDescriptorResult(this.component.getOutputAttributes().getType(), false, attributes);
        OutputMetadataDescriptor descriptor = OutputMetadataDescriptor.builder().withReturnType(outputDescriptor.get()).withAttributesType(attributesDescriptor.get()).build();
        if (!output.isSuccess() || !attributes.isSuccess()) {
            ImmutableList failures = ImmutableList.builder().addAll(output.getFailures()).addAll(attributes.getFailures()).build();
            return MetadataResult.failure(descriptor, (List<MetadataFailure>)failures);
        }
        return MetadataResult.success(descriptor);
    }

    Optional<NamedTypeResolver> getOutputResolver() {
        return this.getOptionalResolver(this.resolverFactory.getOutputResolver());
    }

    Optional<NamedTypeResolver> getOutputAttributesResolver() {
        return this.getOptionalResolver(this.resolverFactory.getOutputAttributesResolver());
    }

    private MetadataResult<MetadataType> getOutputMetadata(MetadataContext context, Object key) {
        OutputModel output = this.component.getOutput();
        if (MetadataTypeUtils.isVoid(output.getType()) || !output.hasDynamicType()) {
            return MetadataResult.success(output.getType());
        }
        try {
            MetadataType metadata = this.resolverFactory.getOutputResolver().getOutputType(context, key);
            if (this.isMetadataResolvedCorrectly(metadata, false)) {
                return MetadataResult.success(this.adaptToListIfNecessary(metadata, key, context));
            }
            MetadataFailure failure = MetadataFailure.Builder.newFailure().withMessage("Error resolving Output Payload metadata").withFailureCode(FailureCode.NO_DYNAMIC_TYPE_AVAILABLE).withReason("NullType is not a valid type for this element").onOutputPayload();
            return MetadataResult.failure(output.getType(), failure);
        }
        catch (Exception e) {
            return MetadataResult.failure(output.getType(), MetadataFailure.Builder.newFailure(e).onOutputAttributes());
        }
    }

    private MetadataResult<MetadataType> getOutputAttributesMetadata(MetadataContext context, Object key) {
        OutputModel attributes = this.component.getOutputAttributes();
        if (MetadataTypeUtils.isVoid(attributes.getType()) || !attributes.hasDynamicType()) {
            return MetadataResult.success(attributes.getType());
        }
        try {
            MetadataType metadata = this.resolverFactory.getOutputAttributesResolver().getAttributesType(context, key);
            if (this.isMetadataResolvedCorrectly(metadata, false)) {
                return MetadataResult.success(metadata);
            }
            MetadataFailure failure = MetadataFailure.Builder.newFailure().withMessage("Error resolving Output Attributes metadata").withFailureCode(FailureCode.NO_DYNAMIC_TYPE_AVAILABLE).withReason("NullType is not a valid type for this element").onOutputAttributes();
            return MetadataResult.failure(attributes.getType(), failure);
        }
        catch (Exception e) {
            return MetadataResult.failure(attributes.getType(), MetadataFailure.Builder.newFailure(e).onOutputAttributes());
        }
    }

    private MetadataResult<TypeMetadataDescriptor> toMetadataDescriptorResult(MetadataType type, boolean isDynamic, MetadataResult<MetadataType> result) {
        MetadataType resultingType = result.get() == null ? type : result.get();
        TypeMetadataDescriptor descriptor = TypeMetadataDescriptor.builder().withType(resultingType).dynamic(isDynamic).build();
        return result.isSuccess() ? MetadataResult.success(descriptor) : MetadataResult.failure(descriptor, result.getFailures());
    }

    private MetadataType adaptToListIfNecessary(MetadataType resolvedType, Object key, MetadataContext metadataContext) throws MetadataResolvingException {
        if (!(this.component.getOutput().getType() instanceof ArrayType)) {
            return resolvedType;
        }
        MetadataType outputType = ((ArrayType)this.component.getOutput().getType()).getType();
        String typeId = ExtensionMetadataTypeUtils.getId(outputType);
        if (Message.class.getName().equals(typeId)) {
            resolvedType = this.wrapInMessageType(resolvedType, key, metadataContext);
            return metadataContext.getTypeBuilder().arrayType().id(typeId).of(resolvedType).build();
        }
        return resolvedType;
    }

    private MetadataType wrapInMessageType(MetadataType type, Object key, MetadataContext context) throws MetadataResolvingException {
        MetadataResult<MetadataType> attributes = this.getOutputAttributesMetadata(context, key);
        if (attributes.isSuccess()) {
            return new MessageMetadataTypeBuilder().payload(type).attributes(attributes.get()).build();
        }
        throw new MetadataResolvingException("Could not resolve attributes of List<Message> output", attributes.getFailures().stream().map(MetadataFailure::getFailureCode).findFirst().orElse(FailureCode.UNKNOWN));
    }
}

