/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model;

import java.util.Optional;
import org.mule.runtime.api.meta.DescribedObject;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.util.Preconditions;

public final class ExternalLibraryModel
implements NamedObject,
DescribedObject {
    private String name;
    private String description;
    private String fileName;
    private String requiredClassName;

    public static ExternalLibraryModelBuilder builder() {
        return new ExternalLibraryModelBuilder();
    }

    private ExternalLibraryModel() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    public Optional<String> getRequiredClassName() {
        return Optional.ofNullable(this.requiredClassName);
    }

    public static class ExternalLibraryModelBuilder {
        private final ExternalLibraryModel product = new ExternalLibraryModel();

        private ExternalLibraryModelBuilder() {
        }

        public ExternalLibraryModelBuilder withName(String name) {
            Preconditions.checkArgument(name != null && !name.trim().isEmpty(), "name cannot be blank");
            this.product.name = name;
            return this;
        }

        public ExternalLibraryModelBuilder withDescription(String description) {
            this.product.description = description;
            return this;
        }

        public ExternalLibraryModelBuilder withFileName(String fileName) {
            this.product.fileName = fileName;
            return this;
        }

        public ExternalLibraryModelBuilder withRequiredClassName(String requiredClassName) {
            this.product.requiredClassName = requiredClassName;
            return this;
        }

        public ExternalLibraryModel build() {
            Preconditions.checkState(this.product.name != null, "name was not provided");
            return this.product;
        }
    }
}

