/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.registry.SpiServiceRegistry;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.SchemaResourceFactory;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.DelegatingEntityResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModuleDelegatingEntityResolver
implements EntityResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleDelegatingEntityResolver.class);
    private Set<ExtensionModel> extensions;
    private final EntityResolver entityResolver = new DelegatingEntityResolver(Thread.currentThread().getContextClassLoader());
    private Optional<SchemaResourceFactory> schemaResourceFactory;

    public ModuleDelegatingEntityResolver(Set<ExtensionModel> extensions) {
        this.extensions = extensions;
        SpiServiceRegistry spiServiceRegistry = new SpiServiceRegistry();
        Collection<SchemaResourceFactory> schemaResourceFactories = spiServiceRegistry.lookupProviders(SchemaResourceFactory.class, this.getClass().getClassLoader());
        if (schemaResourceFactories.isEmpty()) {
            this.schemaResourceFactory = Optional.empty();
        } else if (schemaResourceFactories.size() == 1) {
            this.schemaResourceFactory = Optional.of(schemaResourceFactories.iterator().next());
        } else {
            throw new IllegalArgumentException(String.format("There are '%s' providers for '%s' when there must be 1 or zero.", schemaResourceFactories.size(), SchemaResourceFactory.class.getName()));
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Looking schema for public identifier(publicId): '%s', system identifier(systemId): '%s'", publicId == null ? "" : publicId, systemId));
        }
        if ((inputSource = this.entityResolver.resolveEntity(publicId, systemId)) == null) {
            inputSource = this.generateModuleXsd(publicId, systemId);
        }
        return inputSource;
    }

    private InputSource generateModuleXsd(String publicId, String systemId) {
        Optional<ExtensionModel> extensionModel;
        InputSource inputSource = null;
        if (this.schemaResourceFactory.isPresent() && (extensionModel = this.extensions.stream().filter(em -> systemId.startsWith(em.getXmlDslModel().getNamespace())).findAny()).isPresent()) {
            InputStream schema = this.getSchema(extensionModel.get());
            inputSource = new InputSource(schema);
            inputSource.setPublicId(publicId);
            inputSource.setSystemId(systemId);
        }
        return inputSource;
    }

    private InputStream getSchema(ExtensionModel extensionModel) {
        Optional<GeneratedResource> generatedResource = this.schemaResourceFactory.get().generateResource(extensionModel, DslResolvingContext.getDefault(this.extensions));
        if (!generatedResource.isPresent()) {
            throw new IllegalStateException(String.format("There were no schema generators available when trying to work with the extension '%s'", extensionModel.getName()));
        }
        return new ByteArrayInputStream(generatedResource.get().getContent());
    }
}

