/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.config.spring.NotificationConfig;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.notification.ServerNotificationListener;
import org.mule.runtime.core.context.notification.ListenerSubscriptionPair;
import org.mule.runtime.core.context.notification.ServerNotificationManager;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class ServerNotificationManagerConfigurator
extends AbstractAnnotatedObject
implements Initialisable {
    @Inject
    private MuleContext muleContext;
    @Inject
    private ApplicationContext applicationContext;
    private Boolean dynamic;
    private List<NotificationConfig> enabledNotifications = new ArrayList<NotificationConfig>();
    private List<NotificationConfig> disabledNotifications = new ArrayList<NotificationConfig>();
    private Collection<ListenerSubscriptionPair> notificationListeners;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() {
        ServerNotificationManager notificationManager = this.muleContext.getNotificationManager();
        if (this.dynamic != null) {
            notificationManager.setNotificationDynamic(this.dynamic);
        }
        this.enableNotifications(notificationManager);
        this.disableNotifications(notificationManager);
        Set<ListenerSubscriptionPair> subs = this.getMergedListeners(notificationManager);
        for (ListenerSubscriptionPair sub : subs) {
            if (!notificationManager.isListenerRegistered(sub.getListener())) {
                notificationManager.addListenerSubscriptionPair(sub);
                continue;
            }
            notificationManager.removeListener(sub.getListener());
            notificationManager.addListenerSubscriptionPair(sub);
        }
    }

    private void disableNotifications(ServerNotificationManager notificationManager) {
        for (NotificationConfig disabledNotification : this.disabledNotifications) {
            BiConsumer<DisableNotificationTask, Class> disableNotificationFunction = (disableFunction, type) -> {
                try {
                    disableFunction.run();
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Fail trying to disable a notification of type %s since such type does not exists", type)), (Throwable)e);
                }
            };
            if (disabledNotification.isInterfaceExplicitlyConfigured()) {
                disableNotificationFunction.accept(() -> notificationManager.disableInterface(disabledNotification.getInterfaceClass().get()), disabledNotification.getInterfaceClass().get());
            }
            if (!disabledNotification.isEventExplicitlyConfigured()) continue;
            disableNotificationFunction.accept(() -> notificationManager.disableType(disabledNotification.getEventClass().get()), disabledNotification.getEventClass().get());
        }
    }

    private void enableNotifications(ServerNotificationManager notificationManager) {
        for (NotificationConfig notification : this.enabledNotifications) {
            notificationManager.addInterfaceToType(notification.getInterfaceClass().get(), notification.getEventClass().get());
        }
    }

    protected Set<ListenerSubscriptionPair> getMergedListeners(ServerNotificationManager notificationManager) {
        HashSet<ListenerSubscriptionPair> mergedListeners = new HashSet<ListenerSubscriptionPair>();
        String[] listenerBeans = this.applicationContext.getBeanNamesForType(ServerNotificationListener.class, false, true);
        HashSet<ListenerSubscriptionPair> adhocListeners = new HashSet<ListenerSubscriptionPair>();
        for (String name : listenerBeans) {
            adhocListeners.add(new ListenerSubscriptionPair((ServerNotificationListener)this.applicationContext.getBean(name), null));
        }
        if (this.notificationListeners != null) {
            mergedListeners.addAll(this.notificationListeners);
            for (ListenerSubscriptionPair candidate : adhocListeners) {
                boolean explicityDefined = false;
                for (ListenerSubscriptionPair explicitListener : this.notificationListeners) {
                    if (!candidate.getListener().equals(explicitListener.getListener())) continue;
                    explicityDefined = true;
                    break;
                }
                if (explicityDefined) continue;
                mergedListeners.add(candidate);
            }
        } else {
            mergedListeners.addAll(adhocListeners);
        }
        return mergedListeners;
    }

    public void setNotificationDynamic(boolean dynamic) {
        this.dynamic = new Boolean(dynamic);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setEnabledNotifications(List<NotificationConfig> enabledNotifications) {
        this.enabledNotifications = enabledNotifications;
    }

    public void setNotificationListeners(Collection<ListenerSubscriptionPair> notificationListeners) {
        this.notificationListeners = notificationListeners;
    }

    public void setDisabledNotifications(List<NotificationConfig> disabledNotifications) {
        this.disabledNotifications = disabledNotifications;
    }

    static interface DisableNotificationTask {
        public void run() throws ClassNotFoundException;
    }
}

