/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.processor;

import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.transformer.AbstractTransformer;
import org.mule.runtime.dsl.api.component.AbstractAnnotatedObjectFactory;

public class TransformerObjectFactory
extends AbstractAnnotatedObjectFactory<Transformer> {
    private Class<? extends AbstractTransformer> transformerClass;
    private String name;
    private boolean ignoreBadInput;
    private String returnClass;
    private String encoding;
    private String mimeType;

    @Override
    public final Transformer doGetObject() throws Exception {
        AbstractTransformer transformerInstance = this.createInstance();
        if (this.returnClass != null || this.mimeType != null) {
            DataTypeParamsBuilder builder = DataType.builder().type(this.getReturnType());
            if (StringUtils.isNotEmpty((String)this.mimeType)) {
                builder.mediaType(this.mimeType);
            }
            transformerInstance.setReturnDataType(builder.charset(this.encoding).build());
        }
        transformerInstance.setIgnoreBadInput(this.ignoreBadInput);
        transformerInstance.setName(this.name);
        this.postProcessInstance(transformerInstance);
        return transformerInstance;
    }

    protected void postProcessInstance(AbstractTransformer transformerInstance) {
    }

    protected AbstractTransformer createInstance() {
        Preconditions.checkArgument(this.transformerClass != null, "Default createInstance method is used but no transformerClass was provided");
        try {
            return org.mule.runtime.core.api.util.ClassUtils.instantiateClass(this.transformerClass, new Object[0]);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }

    private Class<?> getReturnType() {
        Class returnType = Object.class;
        if (this.returnClass != null) {
            try {
                returnType = ClassUtils.getClass((String)this.returnClass);
            }
            catch (ClassNotFoundException e) {
                throw new MuleRuntimeException(e);
            }
        }
        return returnType;
    }

    public void setTransformerClass(Class<? extends AbstractTransformer> transformerClass) {
        this.transformerClass = transformerClass;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReturnClass(String returnClass) {
        this.returnClass = returnClass;
    }

    public void setIgnoreBadInput(boolean ignoreBadInput) {
        this.ignoreBadInput = ignoreBadInput;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

