/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.locator;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.util.Preconditions;

public interface Location {
    public String getGlobalComponentName();

    public List<String> getParts();

    public static Builder builder() {
        return new LocationBuilder();
    }

    public static class LocationBuilder
    implements Builder {
        private LocationImpl location = new LocationImpl();
        private boolean globalNameAlreadySet = false;

        @Override
        public Builder globalName(String globalName) {
            this.globalNameAlreadySet = true;
            this.verifyPartDoesNotContainsSlash(globalName);
            LocationBuilder locationBuilder = this.builderCopy();
            locationBuilder.location.parts.add(0, globalName);
            return locationBuilder;
        }

        @Override
        public Builder addPart(String part) {
            this.verifyPartDoesNotContainsSlash(part);
            LocationBuilder locationBuilder = this.builderCopy();
            locationBuilder.location.parts.addLast(part);
            return locationBuilder;
        }

        @Override
        public Builder addProcessorsPart() {
            LocationBuilder locationBuilder = this.builderCopy();
            locationBuilder.location.parts.add("processors");
            return locationBuilder;
        }

        @Override
        public Builder addIndexPart(int index) {
            this.verifyPreviousPartIsNotIndex();
            LocationBuilder locationBuilder = this.builderCopy();
            locationBuilder.location.parts.addLast(String.valueOf(index));
            return locationBuilder;
        }

        private void verifyPreviousPartIsNotIndex() {
            Preconditions.checkState(!this.location.parts.isEmpty(), "An index cannot be the first part");
            try {
                Integer.parseInt((String)this.location.parts.getLast());
                Preconditions.checkState(false, "A location cannot have two consecutive index");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private LocationBuilder builderCopy() {
            LocationBuilder locationBuilder = new LocationBuilder();
            locationBuilder.globalNameAlreadySet = this.globalNameAlreadySet;
            locationBuilder.location.parts.addAll(this.location.parts);
            return locationBuilder;
        }

        private void verifyPartDoesNotContainsSlash(String part) {
            Preconditions.checkArgument(!part.contains("/"), "Slash cannot be part of the global name or part, bad part is " + part);
        }

        @Override
        public Location build() {
            Preconditions.checkState(this.globalNameAlreadySet, "global component name must be set");
            return this.location;
        }
    }

    public static class LocationImpl
    implements Location {
        protected static final String PARTS_SEPARATOR = "/";
        private LinkedList<String> parts = new LinkedList();

        @Override
        public String getGlobalComponentName() {
            return this.parts.get(0);
        }

        @Override
        public List<String> getParts() {
            return this.parts.subList(1, this.parts.size() - 1);
        }

        public String toString() {
            return StringUtils.join(this.parts, (String)PARTS_SEPARATOR);
        }
    }

    public static interface Builder {
        public Builder globalName(String var1);

        public Builder addPart(String var1);

        public Builder addProcessorsPart();

        public Builder addIndexPart(int var1);

        public Location build();
    }
}

