/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.component;

import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.component.LifecycleAdapter;
import org.mule.runtime.core.api.lifecycle.InitialisationCallback;
import org.mule.runtime.core.api.model.EntryPointResolverSet;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.api.util.pool.LifecyleEnabledObjectPool;
import org.mule.runtime.core.component.AbstractJavaComponent;
import org.mule.runtime.core.internal.pool.DefaultLifecycleEnabledObjectPool;

public class PooledJavaComponent
extends AbstractJavaComponent {
    protected PoolingProfile poolingProfile;
    protected LifecyleEnabledObjectPool lifecycleAdapterPool;

    public PooledJavaComponent() {
    }

    public PooledJavaComponent(ObjectFactory objectFactory) {
        this(objectFactory, (PoolingProfile)null);
    }

    public PooledJavaComponent(ObjectFactory objectFactory, PoolingProfile poolingProfile) {
        super(objectFactory);
        this.poolingProfile = poolingProfile;
    }

    public PooledJavaComponent(ObjectFactory objectFactory, PoolingProfile poolingProfile, EntryPointResolverSet entryPointResolverSet) {
        super(objectFactory, entryPointResolverSet);
        this.poolingProfile = poolingProfile;
    }

    @Override
    protected LifecycleAdapter borrowComponentLifecycleAdaptor() throws Exception {
        return (LifecycleAdapter)this.lifecycleAdapterPool.borrowObject();
    }

    @Override
    protected void returnComponentLifecycleAdaptor(LifecycleAdapter lifecycleAdapter) {
        this.lifecycleAdapterPool.returnObject(lifecycleAdapter);
    }

    @Override
    protected void doStart() throws MuleException {
        super.doStart();
        this.lifecycleAdapterPool = new DefaultLifecycleEnabledObjectPool(new LifeCycleAdapterFactory(), this.poolingProfile, this.muleContext);
        this.lifecycleAdapterPool.initialise();
        this.lifecycleAdapterPool.start();
    }

    @Override
    protected void doStop() throws MuleException {
        super.doStop();
        if (this.lifecycleAdapterPool != null) {
            this.lifecycleAdapterPool.stop();
            this.lifecycleAdapterPool.close();
            this.lifecycleAdapterPool = null;
        }
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    protected class LifeCycleAdapterFactory
    implements ObjectFactory {
        protected LifeCycleAdapterFactory() {
        }

        @Override
        public Object getInstance(MuleContext context) throws Exception {
            return PooledJavaComponent.this.createLifecycleAdaptor();
        }

        @Override
        public Class<?> getObjectClass() {
            return LifecycleAdapter.class;
        }

        @Override
        public void initialise() throws InitialisationException {
            PooledJavaComponent.this.objectFactory.initialise();
        }

        @Override
        public void dispose() {
            PooledJavaComponent.this.objectFactory.dispose();
        }

        @Override
        public void addObjectInitialisationCallback(InitialisationCallback callback) {
            PooledJavaComponent.this.objectFactory.addObjectInitialisationCallback(callback);
        }

        @Override
        public boolean isSingleton() {
            return false;
        }

        @Override
        public boolean isExternallyManagedLifecycle() {
            return PooledJavaComponent.this.objectFactory.isExternallyManagedLifecycle();
        }

        @Override
        public boolean isAutoWireObject() {
            return PooledJavaComponent.this.objectFactory.isAutoWireObject();
        }
    }
}

