/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.config.HasPoolingProfile;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionProviderWrapper<C>
implements ConnectionProvider<C>,
HasPoolingProfile,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionProviderWrapper.class);
    @Inject
    protected MuleContext muleContext;
    private final ConnectionProvider<C> delegate;

    ConnectionProviderWrapper(ConnectionProvider<C> delegate) {
        this.delegate = delegate;
    }

    @Override
    public C connect() throws ConnectionException {
        try {
            return this.delegate.connect();
        }
        catch (ConnectionException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    @Override
    public ConnectionValidationResult validate(C connection) {
        return this.delegate.validate(connection);
    }

    @Override
    public void disconnect(C connection) {
        this.delegate.disconnect(connection);
    }

    public ConnectionProvider<C> getDelegate() {
        return this.delegate;
    }

    public abstract RetryPolicyTemplate getRetryPolicyTemplate();

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.delegate, true, this.muleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.getRetryPolicyTemplate(), true, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.delegate);
        LifecycleUtils.startIfNeeded(this.getRetryPolicyTemplate());
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.delegate);
        LifecycleUtils.stopIfNeeded(this.getRetryPolicyTemplate());
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.getRetryPolicyTemplate(), LOGGER);
    }

    @Override
    public Optional<PoolingProfile> getPoolingProfile() {
        return Optional.empty();
    }

    public static ConnectionProvider unwrapProviderWrapper(ConnectionProvider connectionProvider) {
        return connectionProvider instanceof ConnectionProviderWrapper ? ConnectionProviderWrapper.unwrapProviderWrapper(((ConnectionProviderWrapper)connectionProvider).getDelegate()) : connectionProvider;
    }
}

