/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.strategy;

import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.processor.strategy.ReactorProcessingStrategyFactory;
import org.mule.runtime.core.processor.strategy.ReactorStreamProcessingStrategyFactory;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class ProactorStreamProcessingStrategyFactory
extends ReactorStreamProcessingStrategyFactory {
    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        if (this.getMaxConcurrency() == 1) {
            return new ReactorProcessingStrategyFactory().create(muleContext, schedulersNamePrefix);
        }
        return new ProactorStreamProcessingStrategy(() -> muleContext.getSchedulerService().customScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + RING_BUFFER_SCHEDULER_NAME_SUFFIX).withMaxConcurrentTasks(this.getSubscriberCount() + 1)), this.getBufferSize(), this.getSubscriberCount(), this.getWaitStrategy(), () -> muleContext.getSchedulerService().cpuLightScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_LITE.name())), () -> muleContext.getSchedulerService().ioScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.BLOCKING.name())), () -> muleContext.getSchedulerService().cpuIntensiveScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_INTENSIVE.name())), this.getMaxConcurrency());
    }

    static class ProactorStreamProcessingStrategy
    extends ReactorStreamProcessingStrategyFactory.ReactorStreamProcessingStrategy {
        private Supplier<Scheduler> blockingSchedulerSupplier;
        private Supplier<Scheduler> cpuIntensiveSchedulerSupplier;
        private Scheduler blockingScheduler;
        private Scheduler cpuIntensiveScheduler;

        public ProactorStreamProcessingStrategy(Supplier<Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscriberCount, String waitStrategy, Supplier<Scheduler> cpuLightSchedulerSupplier, Supplier<Scheduler> blockingSchedulerSupplier, Supplier<Scheduler> cpuIntensiveSchedulerSupplier, int maxConcurrency) {
            super(ringBufferSchedulerSupplier, bufferSize, subscriberCount, waitStrategy, cpuLightSchedulerSupplier, maxConcurrency);
            this.blockingSchedulerSupplier = blockingSchedulerSupplier;
            this.cpuIntensiveSchedulerSupplier = cpuIntensiveSchedulerSupplier;
        }

        @Override
        public void start() throws MuleException {
            super.start();
            this.blockingScheduler = this.blockingSchedulerSupplier.get();
            this.cpuIntensiveScheduler = this.cpuIntensiveSchedulerSupplier.get();
        }

        @Override
        public void stop() throws MuleException {
            if (this.blockingScheduler != null) {
                this.blockingScheduler.stop();
            }
            if (this.cpuIntensiveScheduler != null) {
                this.cpuIntensiveScheduler.stop();
            }
            super.stop();
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.BLOCKING && this.maxConcurrency > this.subscribers) {
                return this.proactor(processor, this.blockingScheduler);
            }
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_INTENSIVE && this.maxConcurrency > this.subscribers) {
                return this.proactor(processor, this.cpuIntensiveScheduler);
            }
            return super.onProcessor(processor);
        }

        private ReactiveProcessor proactor(ReactiveProcessor processor, Scheduler scheduler) {
            return publisher -> Flux.from((Publisher)publisher).flatMap(event -> Flux.just((Object)event).transform((Function)processor).publishOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.getCpuLightScheduler()))).subscribeOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(scheduler))), this.maxConcurrency);
        }
    }
}

