/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.collections.ListUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.RoutePathNotFoundException;
import org.mule.runtime.core.api.routing.RouterResultsHandler;
import org.mule.runtime.core.api.routing.RouterStatisticsRecorder;
import org.mule.runtime.core.api.routing.SelectiveRouter;
import org.mule.runtime.core.api.routing.filter.Filter;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.management.stats.RouterStatistics;
import org.mule.runtime.core.routing.DefaultRouterResultsHandler;
import org.mule.runtime.core.routing.MessageProcessorFilterPair;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractSelectiveRouter
extends AbstractAnnotatedObject
implements SelectiveRouter,
RouterStatisticsRecorder,
Lifecycle,
FlowConstructAware,
MuleContextAware {
    private final List<MessageProcessorFilterPair> conditionalMessageProcessors = new ArrayList<MessageProcessorFilterPair>();
    private Processor defaultProcessor;
    private final RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    private RouterStatistics routerStatistics;
    final AtomicBoolean initialised = new AtomicBoolean(false);
    final AtomicBoolean starting = new AtomicBoolean(false);
    final AtomicBoolean started = new AtomicBoolean(false);
    private FlowConstruct flowConstruct;
    private MuleContext muleContext;

    public AbstractSelectiveRouter() {
        this.routerStatistics = new RouterStatistics(2);
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
        this.conditionalMessageProcessors.forEach(pair -> pair.setFlowConstruct(flowConstruct));
        this.conditionalMessageProcessors.forEach(pair -> pair.setMuleContext(this.muleContext));
        LifecycleUtils.setMuleContextIfNeeded(this.defaultProcessor, this.muleContext);
        LifecycleUtils.setFlowConstructIfNeeded(this.defaultProcessor, flowConstruct);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws InitialisationException {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (Object o : this.getLifecycleManagedObjects()) {
                if (o instanceof FlowConstructAware) {
                    ((FlowConstructAware)o).setFlowConstruct(this.flowConstruct);
                }
                if (o instanceof MuleContextAware) {
                    ((MuleContextAware)o).setMuleContext(this.muleContext);
                }
                if (!(o instanceof Initialisable)) continue;
                ((Initialisable)o).initialise();
            }
        }
        this.initialised.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws MuleException {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            this.starting.set(true);
            for (Object o : this.getLifecycleManagedObjects()) {
                if (!(o instanceof Startable)) continue;
                ((Startable)o).start();
            }
            this.started.set(true);
            this.starting.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws MuleException {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (Object o : this.getLifecycleManagedObjects()) {
                if (!(o instanceof Stoppable)) continue;
                ((Stoppable)o).stop();
            }
            this.started.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (Object o : this.getLifecycleManagedObjects()) {
                if (!(o instanceof Disposable)) continue;
                ((Disposable)o).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoute(Processor processor, Filter filter) {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            MessageProcessorFilterPair addedPair = new MessageProcessorFilterPair(processor, filter);
            this.conditionalMessageProcessors.add(this.transitionLifecycleManagedObjectForAddition(addedPair));
        }
    }

    @Override
    public void removeRoute(Processor processor) {
        this.updateRoute(processor, (int index) -> {
            MessageProcessorFilterPair removedPair = this.conditionalMessageProcessors.remove(index);
            this.transitionLifecycleManagedObjectForRemoval(removedPair);
        });
    }

    @Override
    public void updateRoute(Processor processor, Filter filter) {
        this.updateRoute(processor, (int index) -> {
            MessageProcessorFilterPair addedPair = new MessageProcessorFilterPair(processor, filter);
            MessageProcessorFilterPair removedPair = this.conditionalMessageProcessors.set(index, this.transitionLifecycleManagedObjectForAddition(addedPair));
            this.transitionLifecycleManagedObjectForRemoval(removedPair);
        });
    }

    @Override
    public void setDefaultRoute(Processor processor) {
        this.defaultProcessor = processor;
    }

    @Override
    public Event process(Event event) throws MuleException {
        return this.routeWithProcessors(this.getProcessorsToRoute(event), event);
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        return Flux.from(publisher).concatMap(event -> {
            try {
                return Flux.fromIterable(this.getProcessorsToRoute((Event)event)).concatMap(mp -> Flux.just((Object)event).transform((Function)mp)).collectList().handle((list, sink) -> {
                    Event aggregateEvent = this.resultsHandler.aggregateResults((List<Event>)list, (Event)event);
                    if (aggregateEvent != null && !Mono.from(event.getContext().getResponsePublisher()).toFuture().isDone()) {
                        sink.next((Object)aggregateEvent);
                    }
                });
            }
            catch (RoutePathNotFoundException e) {
                return Flux.error((Throwable)new MessagingException((Event)event, e, (Processor)this));
            }
        });
    }

    protected Collection<Processor> getProcessorsToRoute(Event event) throws RoutePathNotFoundException {
        Collection<Processor> selectedProcessors = this.selectProcessors(event, Event.builder(event));
        if (!selectedProcessors.isEmpty()) {
            return selectedProcessors;
        }
        if (this.defaultProcessor != null) {
            return Collections.singleton(this.defaultProcessor);
        }
        if (this.getRouterStatistics() != null && this.getRouterStatistics().isEnabled()) {
            this.getRouterStatistics().incrementNoRoutedMessage();
        }
        throw new RoutePathNotFoundException(I18nMessageFactory.createStaticMessage("Can't process message because no route has been found matching any filter and no default route is defined"), this);
    }

    protected abstract Collection<Processor> selectProcessors(Event var1, Event.Builder var2);

    private Collection<?> getLifecycleManagedObjects() {
        if (this.defaultProcessor == null) {
            return this.conditionalMessageProcessors;
        }
        return ListUtils.union(this.conditionalMessageProcessors, Collections.singletonList(this.defaultProcessor));
    }

    private <O> O transitionLifecycleManagedObjectForAddition(O managedObject) {
        try {
            if (this.flowConstruct != null && managedObject instanceof FlowConstructAware) {
                ((FlowConstructAware)managedObject).setFlowConstruct(this.flowConstruct);
            }
            if (this.muleContext != null && managedObject instanceof MuleContextAware) {
                ((MuleContextAware)managedObject).setMuleContext(this.muleContext);
            }
            if (this.initialised.get() && managedObject instanceof Initialisable) {
                ((Initialisable)managedObject).initialise();
            }
            if (this.started.get() && managedObject instanceof Startable) {
                ((Startable)managedObject).start();
            }
        }
        catch (MuleException me) {
            throw new MuleRuntimeException(me);
        }
        return managedObject;
    }

    private <O> O transitionLifecycleManagedObjectForRemoval(O managedObject) {
        try {
            if (managedObject instanceof Stoppable) {
                ((Stoppable)managedObject).stop();
            }
            if (managedObject instanceof Disposable) {
                ((Disposable)managedObject).dispose();
            }
        }
        catch (MuleException me) {
            throw new MuleRuntimeException(me);
        }
        return managedObject;
    }

    private Event routeWithProcessors(Collection<Processor> processors, Event event) throws MuleException {
        ArrayList<Event> results = new ArrayList<Event>();
        for (Processor processor : processors) {
            this.processEventWithProcessor(event, processor, results);
        }
        return this.resultsHandler.aggregateResults(results, event);
    }

    private void processEventWithProcessor(Event event, Processor processor, List<Event> results) throws MuleException {
        results.add(processor.process(event));
        if (this.getRouterStatistics() != null && this.getRouterStatistics().isEnabled()) {
            this.getRouterStatistics().incrementRoutedMessage(processor);
        }
    }

    public List<MessageProcessorFilterPair> getConditionalMessageProcessors() {
        return Collections.unmodifiableList(this.conditionalMessageProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRoute(Processor processor, RoutesUpdater routesUpdater) {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (int i = 0; i < this.conditionalMessageProcessors.size(); ++i) {
                if (!this.conditionalMessageProcessors.get(i).getMessageProcessor().equals(processor)) continue;
                routesUpdater.updateAt(i);
            }
        }
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }

    @Override
    public void setRouterStatistics(RouterStatistics routerStatistics) {
        this.routerStatistics = routerStatistics;
    }

    public String toString() {
        return String.format("%s [flow-construct=%s, started=%s]", this.getClass().getSimpleName(), this.flowConstruct != null ? this.flowConstruct.getName() : null, this.started);
    }

    private static interface RoutesUpdater {
        public void updateAt(int var1);
    }
}

