/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.dsl.spring;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.config.spring.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.processor.AbstractAttributeDefinitionVisitor;
import org.mule.runtime.config.spring.dsl.processor.xml.XmlCustomAttributeHandler;
import org.mule.runtime.config.spring.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.CollectionBeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.CommonBeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.ComponentModelHelper;
import org.mule.runtime.config.spring.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.spring.dsl.spring.ExceptionStrategyRefBeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.FilterReferenceBeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.InterceptorStackBeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.MapBeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.MapEntryBeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.ObjectFactoryClassRepository;
import org.mule.runtime.config.spring.dsl.spring.PropertiesMapBeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.ReferenceBeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.SimpleTypeBeanDefinitionCreator;
import org.mule.runtime.config.spring.dsl.spring.WrapperElementType;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.component.ComponentAnnotations;
import org.mule.runtime.core.exception.ErrorMapping;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.exception.SingleErrorTypeMatcher;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.KeyAttributeDefinitionPair;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.w3c.dom.Element;

public class BeanDefinitionFactory {
    public static final String SPRING_PROTOTYPE_OBJECT = "prototype";
    public static final String SPRING_SINGLETON_OBJECT = "singleton";
    public static final String SOURCE_TYPE = "sourceType";
    public static final String TARGET_TYPE = "targetType";
    private final ImmutableSet<ComponentIdentifier> ignoredMuleCoreComponentIdentifiers = ImmutableSet.builder().add((Object)ApplicationModel.MULE_IDENTIFIER).add((Object)ApplicationModel.MULE_DOMAIN_IDENTIFIER).add((Object)ApplicationModel.MULE_EE_DOMAIN_IDENTIFIER).add((Object)ApplicationModel.ERROR_MAPPING_IDENTIFIER).add((Object)ApplicationModel.DESCRIPTION_IDENTIFIER).add((Object)ApplicationModel.ANNOTATIONS_ELEMENT_IDENTIFIER).add((Object)ApplicationModel.DOC_DESCRIPTION_IDENTIFIER).add((Object)ApplicationModel.SPRING_PROPERTY_PLACEHOLDER_IDENTIFIER).build();
    private final ImmutableSet<ComponentIdentifier> customBuildersComponentIdentifiers = ImmutableSet.builder().add((Object)ApplicationModel.MULE_PROPERTIES_IDENTIFIER).add((Object)ApplicationModel.MULE_PROPERTY_IDENTIFIER).add((Object)ApplicationModel.SPRING_ENTRY_IDENTIFIER).add((Object)ApplicationModel.SPRING_LIST_IDENTIFIER).add((Object)ApplicationModel.SPRING_MAP_IDENTIFIER).add((Object)ApplicationModel.SPRING_VALUE_IDENTIFIER).add((Object)ApplicationModel.INTERCEPTOR_STACK_IDENTIFIER).build();
    private ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry;
    private BeanDefinitionCreator componentModelProcessor;
    private ErrorTypeRepository errorTypeRepository;
    private ObjectFactoryClassRepository objectFactoryClassRepository = new ObjectFactoryClassRepository();

    public BeanDefinitionFactory(ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry, ErrorTypeRepository errorTypeRepository) {
        this.componentBuildingDefinitionRegistry = componentBuildingDefinitionRegistry;
        this.errorTypeRepository = errorTypeRepository;
        this.componentModelProcessor = this.buildComponentModelProcessorChainOfResponsability();
    }

    public BeanDefinition resolveComponentRecursively(ComponentModel parentComponentModel, ComponentModel componentModel, BeanDefinitionRegistry registry, BiConsumer<ComponentModel, BeanDefinitionRegistry> componentModelPostProcessor, BiFunction<Element, BeanDefinition, Either<BeanDefinition, BeanReference>> oldParsingMechanism) {
        List<ComponentModel> innerComponents = componentModel.getInnerComponents();
        if (!innerComponents.isEmpty()) {
            for (ComponentModel innerComponent : innerComponents) {
                if (!innerComponent.isEnabled()) continue;
                if (this.hasDefinition(innerComponent.getIdentifier(), Optional.of(innerComponent.getParent().getIdentifier()))) {
                    this.resolveComponentRecursively(componentModel, innerComponent, registry, componentModelPostProcessor, oldParsingMechanism);
                    continue;
                }
                Either<BeanDefinition, BeanReference> oldParseResult = oldParsingMechanism.apply((Element)XmlCustomAttributeHandler.from(innerComponent).getNode(), null);
                if (oldParseResult.isLeft()) {
                    AbstractBeanDefinition oldBeanDefinition = (AbstractBeanDefinition)oldParseResult.getLeft();
                    oldBeanDefinition = CommonBeanDefinitionCreator.adaptFilterBeanDefinitions(componentModel, oldBeanDefinition);
                    innerComponent.setBeanDefinition((BeanDefinition)oldBeanDefinition);
                    continue;
                }
                if (!oldParseResult.isRight()) continue;
                innerComponent.setBeanReference(oldParseResult.getRight());
            }
        }
        return this.resolveComponent(parentComponentModel, componentModel, registry, componentModelPostProcessor);
    }

    private BeanDefinition resolveComponent(ComponentModel parentComponentModel, ComponentModel componentModel, BeanDefinitionRegistry registry, BiConsumer<ComponentModel, BeanDefinitionRegistry> componentDefinitionModelProcessor) {
        if (this.ignoredMuleCoreComponentIdentifiers.contains((Object)componentModel.getIdentifier()) || !componentModel.isEnabled()) {
            return null;
        }
        this.resolveComponentBeanDefinition(parentComponentModel, componentModel);
        componentDefinitionModelProcessor.accept(componentModel, registry);
        this.processMuleConfiguration(componentModel, registry);
        this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier()).ifPresent(componentBuildingDefinition -> {
            if (componentModel.getType() != null && AnnotatedObject.class.isAssignableFrom(componentModel.getType())) {
                ComponentModelHelper.addAnnotation(ComponentAnnotations.ANNOTATION_NAME, componentModel.getIdentifier(), componentModel);
                ComponentModelHelper.addAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS, new HashMap<String, String>(componentModel.getParameters()), componentModel);
                List errorMappingComponents = componentModel.getInnerComponents().stream().filter(innerComponent -> ApplicationModel.ERROR_MAPPING_IDENTIFIER.equals(innerComponent.getIdentifier())).collect(Collectors.toList());
                if (!errorMappingComponents.isEmpty()) {
                    ComponentModelHelper.addAnnotation(ErrorMapping.ANNOTATION_ERROR_MAPPINGS, errorMappingComponents.stream().map(innerComponent -> {
                        Map<String, String> parameters = innerComponent.getParameters();
                        ComponentIdentifier source = ComponentIdentifier.buildFromStringRepresentation(parameters.get(SOURCE_TYPE));
                        ComponentIdentifier target = ComponentIdentifier.buildFromStringRepresentation(parameters.get(TARGET_TYPE));
                        ErrorType errorType = this.errorTypeRepository.lookupErrorType(source).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Unable to find error '%s' from Error Type Repository", source)));
                        SingleErrorTypeMatcher errorTypeMatcher = new SingleErrorTypeMatcher(errorType);
                        ErrorType targetType = this.resolveErrorType(target);
                        return new ErrorMapping(errorTypeMatcher, targetType);
                    }).collect(Collectors.toList()), componentModel);
                }
            }
        });
        ComponentModelHelper.addAnnotation(AbstractAnnotatedObject.LOCATION_KEY, componentModel.getComponentLocation(), componentModel);
        BeanDefinition beanDefinition = componentModel.getBeanDefinition();
        return beanDefinition;
    }

    private ErrorType resolveErrorType(ComponentIdentifier errorIdentifier) {
        Optional<ErrorType> optionalErrorType = this.errorTypeRepository.lookupErrorType(errorIdentifier);
        return optionalErrorType.isPresent() ? optionalErrorType.get() : this.errorTypeRepository.addErrorType(errorIdentifier, this.errorTypeRepository.getAnyErrorType());
    }

    private void processMuleConfiguration(ComponentModel componentModel, BeanDefinitionRegistry registry) {
        if (componentModel.getIdentifier().equals(ApplicationModel.CONFIGURATION_IDENTIFIER)) {
            AtomicReference defaultRetryPolicyTemplate = new AtomicReference();
            componentModel.getInnerComponents().stream().forEach(childComponentModel -> {
                if (CommonBeanDefinitionCreator.areMatchingTypes(RetryPolicyTemplate.class, childComponentModel.getType())) {
                    defaultRetryPolicyTemplate.set(childComponentModel.getBeanDefinition());
                }
            });
            if (defaultRetryPolicyTemplate.get() != null) {
                registry.registerBeanDefinition("_defaultRetryPolicyTemplate", (BeanDefinition)defaultRetryPolicyTemplate.get());
            }
        }
    }

    private void resolveComponentBeanDefinition(ComponentModel parentComponentModel, ComponentModel componentModel) {
        Optional<ComponentBuildingDefinition> buildingDefinitionOptional = this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getIdentifier());
        if (buildingDefinitionOptional.isPresent() || this.customBuildersComponentIdentifiers.contains((Object)componentModel.getIdentifier())) {
            this.componentModelProcessor.processRequest(new CreateBeanDefinitionRequest(parentComponentModel, componentModel, buildingDefinitionOptional.orElse(null)));
        } else {
            boolean isWrapperComponent = this.isWrapperComponent(componentModel.getIdentifier(), Optional.of(parentComponentModel.getIdentifier()));
            if (!isWrapperComponent) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("No component building definition for element %s. It may be that there's a dependency missing to the project that handle that extension.", componentModel.getIdentifier())));
            }
            this.processComponentWrapper(componentModel);
        }
    }

    private void processComponentWrapper(ComponentModel componentModel) {
        ComponentBuildingDefinition parentBuildingDefinition = this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentModel.getParent().getIdentifier()).get();
        Map<String, WrapperElementType> wrapperIdentifierAndTypeMap = this.getWrapperIdentifierAndTypeMap(parentBuildingDefinition);
        WrapperElementType wrapperElementType = wrapperIdentifierAndTypeMap.get(componentModel.getIdentifier().getName());
        if (!wrapperElementType.equals((Object)WrapperElementType.SINGLE)) {
            throw new IllegalStateException(String.format("Element %s does not have a building definition and it should since it's of type %s", new Object[]{componentModel.getIdentifier(), wrapperElementType}));
        }
        componentModel.setType(componentModel.getInnerComponents().get(0).getType());
        componentModel.setBeanDefinition(componentModel.getInnerComponents().get(0).getBeanDefinition());
        componentModel.setBeanReference(componentModel.getInnerComponents().get(0).getBeanReference());
    }

    public static void checkElementNameUnique(BeanDefinitionRegistry registry, Element element) {
        String name;
        if (null != element.getAttributeNode("name") && registry.containsBeanDefinition(name = element.getAttribute("name"))) {
            throw new IllegalArgumentException("A component named " + name + " already exists.");
        }
    }

    private BeanDefinitionCreator buildComponentModelProcessorChainOfResponsability() {
        ExceptionStrategyRefBeanDefinitionCreator exceptionStrategyRefBeanDefinitionCreator = new ExceptionStrategyRefBeanDefinitionCreator();
        PropertiesMapBeanDefinitionCreator propertiesMapBeanDefinitionCreator = new PropertiesMapBeanDefinitionCreator();
        InterceptorStackBeanDefinitionCreator interceptorStackBeanDefinitionCreator = new InterceptorStackBeanDefinitionCreator();
        FilterReferenceBeanDefinitionCreator filterReferenceBeanDefinitionCreator = new FilterReferenceBeanDefinitionCreator();
        ReferenceBeanDefinitionCreator referenceBeanDefinitionCreator = new ReferenceBeanDefinitionCreator();
        SimpleTypeBeanDefinitionCreator simpleTypeBeanDefinitionCreator = new SimpleTypeBeanDefinitionCreator();
        CollectionBeanDefinitionCreator collectionBeanDefinitionCreator = new CollectionBeanDefinitionCreator();
        MapEntryBeanDefinitionCreator mapEntryBeanDefinitionCreator = new MapEntryBeanDefinitionCreator();
        MapBeanDefinitionCreator mapBeanDefinitionCreator = new MapBeanDefinitionCreator();
        CommonBeanDefinitionCreator commonComponentModelProcessor = new CommonBeanDefinitionCreator(this.objectFactoryClassRepository);
        propertiesMapBeanDefinitionCreator.setNext(interceptorStackBeanDefinitionCreator);
        interceptorStackBeanDefinitionCreator.setNext(exceptionStrategyRefBeanDefinitionCreator);
        exceptionStrategyRefBeanDefinitionCreator.setNext(exceptionStrategyRefBeanDefinitionCreator);
        exceptionStrategyRefBeanDefinitionCreator.setNext(filterReferenceBeanDefinitionCreator);
        filterReferenceBeanDefinitionCreator.setNext(referenceBeanDefinitionCreator);
        referenceBeanDefinitionCreator.setNext(simpleTypeBeanDefinitionCreator);
        simpleTypeBeanDefinitionCreator.setNext(collectionBeanDefinitionCreator);
        collectionBeanDefinitionCreator.setNext(mapEntryBeanDefinitionCreator);
        mapEntryBeanDefinitionCreator.setNext(mapBeanDefinitionCreator);
        mapBeanDefinitionCreator.setNext(commonComponentModelProcessor);
        return propertiesMapBeanDefinitionCreator;
    }

    public boolean hasDefinition(ComponentIdentifier componentIdentifier, Optional<ComponentIdentifier> parentComponentModelOptional) {
        return this.ignoredMuleCoreComponentIdentifiers.contains((Object)componentIdentifier) || this.customBuildersComponentIdentifiers.contains((Object)componentIdentifier) || this.componentBuildingDefinitionRegistry.getBuildingDefinition(componentIdentifier).isPresent() || this.isWrapperComponent(componentIdentifier, parentComponentModelOptional);
    }

    public boolean isWrapperComponent(ComponentIdentifier componentModel, Optional<ComponentIdentifier> parentComponentModelOptional) {
        if (!parentComponentModelOptional.isPresent()) {
            return false;
        }
        Optional<ComponentBuildingDefinition> buildingDefinitionOptional = this.componentBuildingDefinitionRegistry.getBuildingDefinition(parentComponentModelOptional.get());
        if (!buildingDefinitionOptional.isPresent()) {
            return false;
        }
        Map<String, WrapperElementType> wrapperIdentifierAndTypeMap = this.getWrapperIdentifierAndTypeMap(buildingDefinitionOptional.get());
        return wrapperIdentifierAndTypeMap.containsKey(componentModel.getName());
    }

    private Map<String, WrapperElementType> getWrapperIdentifierAndTypeMap(ComponentBuildingDefinition buildingDefinition) {
        final HashMap<String, WrapperElementType> wrapperIdentifierAndTypeMap = new HashMap<String, WrapperElementType>();
        AbstractAttributeDefinitionVisitor wrapperIdentifiersCollector = new AbstractAttributeDefinitionVisitor(){

            @Override
            public void onComplexChildCollection(Class<?> type, Optional<String> wrapperIdentifierOptional) {
                wrapperIdentifierOptional.ifPresent(wrapperIdentifier -> wrapperIdentifierAndTypeMap.put(wrapperIdentifier, WrapperElementType.COLLECTION));
            }

            @Override
            public void onComplexChild(Class<?> type, Optional<String> wrapperIdentifierOptional, Optional<String> childIdentifier) {
                wrapperIdentifierOptional.ifPresent(wrapperIdentifier -> wrapperIdentifierAndTypeMap.put(wrapperIdentifier, WrapperElementType.SINGLE));
            }

            @Override
            public void onComplexChildMap(Class<?> keyType, Class<?> valueType, String wrapperIdentifier) {
                wrapperIdentifierAndTypeMap.put(wrapperIdentifier, WrapperElementType.MAP);
            }

            @Override
            public void onMultipleValues(KeyAttributeDefinitionPair[] definitions) {
                for (KeyAttributeDefinitionPair attributeDefinition : definitions) {
                    attributeDefinition.getAttributeDefinition().accept(this);
                }
            }
        };
        Consumer<AttributeDefinition> collectWrappersConsumer = attributeDefinition -> attributeDefinition.accept(wrapperIdentifiersCollector);
        buildingDefinition.getSetterParameterDefinitions().stream().map(setterAttributeDefinition -> setterAttributeDefinition.getAttributeDefinition()).forEach(collectWrappersConsumer);
        buildingDefinition.getConstructorAttributeDefinition().stream().forEach(collectWrappersConsumer);
        return wrapperIdentifierAndTypeMap;
    }

    public void destroy() {
        this.objectFactoryClassRepository.destroy();
    }
}

