/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.config.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleMessageHandler {
    protected static final Logger logger = LoggerFactory.getLogger(LocaleMessageHandler.class);

    public static String getString(String bundleName, String code) {
        return LocaleMessageHandler.getString(bundleName, code, new Object[0]);
    }

    public static String getString(String bundleName, String code, Object arg1) {
        if (arg1 == null) {
            arg1 = "null";
        }
        return LocaleMessageHandler.getString(bundleName, code, new Object[]{arg1});
    }

    public static String getString(String bundleName, String code, Object arg1, Object arg2) {
        if (arg1 == null) {
            arg1 = "null";
        }
        if (arg2 == null) {
            arg2 = "null";
        }
        return LocaleMessageHandler.getString(bundleName, code, new Object[]{arg1, arg2});
    }

    public static String getString(String bundleName, String code, Object[] args) {
        return LocaleMessageHandler.getString(bundleName, Locale.getDefault(), code, args);
    }

    public static String getString(String bundleName, Locale locale, String code, Object[] args) {
        String path = bundleName + "-messages";
        ResourceBundle bundle = ResourceBundle.getBundle(path, locale);
        String m = bundle.getString(code);
        if (m == null) {
            logger.error("Failed to find message for id " + code + " in resource bundle " + path);
            return "";
        }
        return MessageFormat.format(m, args);
    }
}

