/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.construct;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.construct.FlowConstructInvalidException;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.api.exception.MessagingExceptionHandlerAware;
import org.mule.runtime.core.api.lifecycle.LifecycleCallback;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.internal.construct.FlowConstructLifecycleManager;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.core.lifecycle.EmptyLifecycleCallback;
import org.mule.runtime.core.management.stats.FlowConstructStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlowConstruct
extends AbstractAnnotatedObject
implements FlowConstruct,
Lifecycle {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractFlowConstruct.class);
    private final FlowConstructLifecycleManager lifecycleManager;
    protected String name;
    protected MessagingExceptionHandler exceptionListener;
    protected final MuleContext muleContext;
    protected FlowConstructStatistics statistics;
    protected String initialState = "started";

    public AbstractFlowConstruct(String name, MuleContext muleContext) {
        this.muleContext = muleContext;
        this.name = name;
        this.lifecycleManager = new FlowConstructLifecycleManager(this, muleContext);
    }

    @Override
    public final void initialise() throws InitialisationException {
        try {
            if (this.exceptionListener == null) {
                this.exceptionListener = this.muleContext.getDefaultErrorHandler();
            }
            this.lifecycleManager.fireInitialisePhase((phaseName, object) -> {
                this.injectFlowConstructMuleContext(this.exceptionListener);
                this.initialiseIfInitialisable(this.exceptionListener);
                this.validateConstruct();
                this.doInitialise();
            });
        }
        catch (InitialisationException e) {
            FunctionalUtils.safely(() -> this.dispose());
            throw e;
        }
        catch (MuleException e) {
            FunctionalUtils.safely(() -> this.dispose());
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public final void start() throws MuleException {
        if (!this.isStopped() && this.initialState.equals("stopped")) {
            this.lifecycleManager.fireStartPhase((LifecycleCallback<FlowConstruct>)new EmptyLifecycleCallback<FlowConstruct>());
            this.lifecycleManager.fireStopPhase((LifecycleCallback<FlowConstruct>)new EmptyLifecycleCallback<FlowConstruct>());
            LOGGER.info("Flow " + this.name + " has not been started (initial state = 'stopped')");
            return;
        }
        this.lifecycleManager.fireStartPhase((phaseName, object) -> {
            this.startIfStartable(this.exceptionListener);
            this.doStart();
        });
    }

    @Override
    public final void stop() throws MuleException {
        this.lifecycleManager.fireStopPhase((phaseName, object) -> {
            this.doStop();
            this.stopIfStoppable(this.exceptionListener);
        });
    }

    @Override
    public final void dispose() {
        try {
            if (this.isStarted()) {
                this.stop();
            }
            this.lifecycleManager.fireDisposePhase((phaseName, object) -> {
                this.doDispose();
                this.disposeIfDisposable(this.exceptionListener);
            });
        }
        catch (MuleException e) {
            LOGGER.error("Failed to stop service: " + this.name, (Throwable)e);
        }
    }

    public boolean isStarted() {
        return this.lifecycleManager.getState().isStarted();
    }

    public boolean isStopped() {
        return this.lifecycleManager.getState().isStopped();
    }

    public boolean isStopping() {
        return this.lifecycleManager.getState().isStopping();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MessagingExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public String getInitialState() {
        return this.initialState;
    }

    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public FlowConstructStatistics getStatistics() {
        return this.statistics;
    }

    protected void doInitialise() throws MuleException {
        this.configureStatistics();
    }

    protected void configureStatistics() {
        this.statistics = new FlowConstructStatistics(this.getConstructType(), this.name);
        this.statistics.setEnabled(this.muleContext.getStatistics().isEnabled());
        this.muleContext.getStatistics().add(this.statistics);
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    protected void doDispose() {
        this.muleContext.getStatistics().remove(this.statistics);
    }

    protected void validateConstruct() throws FlowConstructInvalidException {
        if (this.exceptionListener instanceof MessagingExceptionHandlerAcceptor && !((MessagingExceptionHandlerAcceptor)this.exceptionListener).acceptsAll()) {
            throw new FlowConstructInvalidException(CoreMessages.createStaticMessage("Flow exception listener contains an exception strategy that doesn't handle all request, Perhaps there's an exception strategy with a when attribute set but it's not part of a catch exception strategy"), this);
        }
    }

    protected void injectFlowConstructMuleContext(Object candidate) {
        if (candidate instanceof FlowConstructAware) {
            ((FlowConstructAware)candidate).setFlowConstruct(this);
        }
        if (candidate instanceof MuleContextAware) {
            ((MuleContextAware)candidate).setMuleContext(this.muleContext);
        }
    }

    protected void injectExceptionHandler(Object candidate) {
        if (candidate instanceof MessagingExceptionHandlerAware) {
            ((MessagingExceptionHandlerAware)candidate).setMessagingExceptionHandler(this.getExceptionListener());
        }
    }

    @Override
    public String getUniqueIdString() {
        return this.muleContext.getUniqueIdString();
    }

    @Override
    public String getServerId() {
        return this.muleContext.getId();
    }

    public String toString() {
        return String.format("%s{%s}", ClassUtils.getSimpleName(this.getClass()), this.getName());
    }

    protected void initialiseIfInitialisable(Object candidate) throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(candidate, true, this.muleContext);
    }

    protected void startIfStartable(Object candidate) throws MuleException {
        LifecycleUtils.startIfNeeded(candidate);
    }

    protected void stopIfStoppable(Object candidate) throws MuleException {
        LifecycleUtils.stopIfNeeded(candidate);
    }

    protected void disposeIfDisposable(Object candidate) {
        LifecycleUtils.disposeIfNeeded(candidate, LOGGER);
    }

    public abstract String getConstructType();
}

