/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence;

import com.google.gson.stream.JsonWriter;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.persistence.DefaultObjectTypeReferenceHandler;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.SerializationContext;

public final class RestrictedTypesObjectTypeReferenceHandler
implements ObjectTypeReferenceHandler {
    private final ObjectTypeReferenceHandler delegateReferenceHandler;
    private final Set<String> allowReferenceTypes;

    public RestrictedTypesObjectTypeReferenceHandler(SerializationContext serializationContext, Set<String> allowReferenceTypes) {
        this.delegateReferenceHandler = new DefaultObjectTypeReferenceHandler(serializationContext);
        this.allowReferenceTypes = allowReferenceTypes;
    }

    @Override
    public Optional<TypeBuilder> readReference(String typeReference) {
        return this.delegateReferenceHandler.readReference(typeReference);
    }

    @Override
    public Optional<String> writeReference(ObjectType type, JsonWriter writer) {
        return MetadataTypeUtils.getTypeId(type).filter(this.allowReferenceTypes::contains).flatMap(s -> this.delegateReferenceHandler.writeReference(type, writer));
    }
}

