/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl;

import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.config.spring.dsl.model.extension.xml.XmlExtensionModelProperty;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.module.extension.internal.config.ExtensionBuildingDefinitionProvider;
import org.mule.runtime.module.extension.internal.config.ExtensionConfig;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.config.ConfigurationDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.connection.ConnectionProviderDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.infrastructure.DynamicConfigPolicyObjectFactory;
import org.mule.runtime.module.extension.internal.config.dsl.infrastructure.DynamicConfigurationExpiration;
import org.mule.runtime.module.extension.internal.config.dsl.infrastructure.DynamicConfigurationExpirationObjectFactory;
import org.mule.runtime.module.extension.internal.config.dsl.infrastructure.ExpirationPolicyObjectFactory;
import org.mule.runtime.module.extension.internal.config.dsl.infrastructure.ExtensionConfigObjectFactory;
import org.mule.runtime.module.extension.internal.config.dsl.operation.OperationDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.ObjectTypeParameterParser;
import org.mule.runtime.module.extension.internal.config.dsl.source.SourceDefinitionParser;
import org.mule.runtime.module.extension.internal.runtime.DynamicConfigPolicy;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class DefaultExtensionBuildingDefinitionProvider
implements ExtensionBuildingDefinitionProvider {
    private final List<ComponentBuildingDefinition> definitions = new LinkedList<ComponentBuildingDefinition>();
    private Set<ExtensionModel> extensions;

    public void setExtensions(Set<ExtensionModel> extensions) {
        this.extensions = extensions;
    }

    @Override
    public void init() {
        Preconditions.checkState(this.extensions != null, "extensions cannot be null");
        this.extensions.stream().filter(this::shouldRegisterExtensionParser).forEach(this::registerExtensionParsers);
    }

    private boolean shouldRegisterExtensionParser(ExtensionModel extensionModel) {
        return !extensionModel.getModelProperty(XmlExtensionModelProperty.class).isPresent();
    }

    @Override
    public List<ComponentBuildingDefinition> getComponentBuildingDefinitions() {
        ComponentBuildingDefinition.Builder baseDefinition = new ComponentBuildingDefinition.Builder().withNamespace("extension");
        this.definitions.add(baseDefinition.copy().withIdentifier("extensions-config").withTypeDefinition(TypeDefinition.fromType(ExtensionConfig.class)).withObjectFactoryType(ExtensionConfigObjectFactory.class).withSetterParameterDefinition("dynamicConfigurationExpiration", AttributeDefinition.Builder.fromChildConfiguration(DynamicConfigurationExpiration.class).build()).build());
        this.definitions.add(baseDefinition.copy().withIdentifier("dynamic-configuration-expiration").withTypeDefinition(TypeDefinition.fromType(DynamicConfigurationExpiration.class)).withObjectFactoryType(DynamicConfigurationExpirationObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("frequency").build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromSimpleParameter("timeUnit", value -> TimeUnit.valueOf((String)value)).build()).build());
        this.definitions.add(baseDefinition.copy().withIdentifier("dynamic-config-policy").withTypeDefinition(TypeDefinition.fromType(DynamicConfigPolicy.class)).withObjectFactoryType(DynamicConfigPolicyObjectFactory.class).withSetterParameterDefinition("expirationPolicy", AttributeDefinition.Builder.fromChildConfiguration(ExpirationPolicy.class).build()).build());
        this.definitions.add(baseDefinition.copy().withIdentifier("expiration-policy").withTypeDefinition(TypeDefinition.fromType(ExpirationPolicy.class)).withObjectFactoryType(ExpirationPolicyObjectFactory.class).withSetterParameterDefinition("maxIdleTime", AttributeDefinition.Builder.fromSimpleParameter("maxIdleTime").build()).withSetterParameterDefinition("timeUnit", AttributeDefinition.Builder.fromSimpleParameter("timeUnit", value -> TimeUnit.valueOf((String)value)).build()).build());
        return this.definitions;
    }

    private void registerExtensionParsers(final ExtensionModel extensionModel) {
        XmlDslModel xmlDslModel = extensionModel.getXmlDslModel();
        final ExtensionParsingContext parsingContext = this.createParsingContext(extensionModel);
        final ComponentBuildingDefinition.Builder definitionBuilder = new ComponentBuildingDefinition.Builder().withNamespace(xmlDslModel.getPrefix());
        final DslSyntaxResolver dslSyntaxResolver = DslSyntaxResolver.getDefault(extensionModel, DslResolvingContext.getDefault(this.extensions));
        final ClassLoader extensionClassLoader = MuleExtensionUtils.getClassLoader(extensionModel);
        ClassUtils.withContextClassLoader(extensionClassLoader, () -> {
            new IdempotentExtensionWalker(){

                @Override
                public void onConfiguration(ConfigurationModel model) {
                    DefaultExtensionBuildingDefinitionProvider.this.parseWith(new ConfigurationDefinitionParser(definitionBuilder, extensionModel, model, dslSyntaxResolver, parsingContext));
                }

                @Override
                public void onOperation(OperationModel model) {
                    DefaultExtensionBuildingDefinitionProvider.this.parseWith(new OperationDefinitionParser(definitionBuilder, extensionModel, model, dslSyntaxResolver, parsingContext));
                }

                @Override
                public void onConnectionProvider(ConnectionProviderModel model) {
                    DefaultExtensionBuildingDefinitionProvider.this.parseWith(new ConnectionProviderDefinitionParser(definitionBuilder, model, extensionModel, dslSyntaxResolver, parsingContext));
                }

                @Override
                public void onSource(SourceModel model) {
                    DefaultExtensionBuildingDefinitionProvider.this.parseWith(new SourceDefinitionParser(definitionBuilder, extensionModel, model, dslSyntaxResolver, parsingContext));
                }

                @Override
                protected void onParameter(ParameterGroupModel groupModel, ParameterModel model) {
                    DefaultExtensionBuildingDefinitionProvider.this.registerTopLevelParameter(model.getType(), definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext);
                }
            }.walk(extensionModel);
            this.registerExportedTypesTopLevelParsers(extensionModel, definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext);
            this.registerSubTypes(definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext);
        });
    }

    private void registerSubTypes(MetadataType type, final ComponentBuildingDefinition.Builder definitionBuilder, final ClassLoader extensionClassLoader, final DslSyntaxResolver dslSyntaxResolver, final ExtensionParsingContext parsingContext) {
        type.accept(new MetadataTypeVisitor(){

            @Override
            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept(this));
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept(this);
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (objectType.isOpen()) {
                    objectType.getOpenRestriction().get().accept(this);
                } else {
                    parsingContext.getSubTypes(objectType).forEach(subtype -> DefaultExtensionBuildingDefinitionProvider.this.registerTopLevelParameter(subtype, definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext));
                }
            }
        });
    }

    private void parseWith(ExtensionDefinitionParser parser) {
        try {
            this.definitions.addAll(parser.parse());
        }
        catch (ConfigurationException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private void registerTopLevelParameter(MetadataType parameterType, final ComponentBuildingDefinition.Builder definitionBuilder, final ClassLoader extensionClassLoader, final DslSyntaxResolver dslSyntaxResolver, final ExtensionParsingContext parsingContext) {
        final Optional<DslElementSyntax> dslElement = dslSyntaxResolver.resolve(parameterType);
        if (!dslElement.isPresent() || parsingContext.isRegistered(dslElement.get().getElementName(), dslElement.get().getPrefix())) {
            return;
        }
        parameterType.accept(new MetadataTypeVisitor(){

            @Override
            public void visitObject(ObjectType objectType) {
                DslElementSyntax pojoDsl = (DslElementSyntax)dslElement.get();
                if (pojoDsl.supportsTopLevelDeclaration() || pojoDsl.supportsChildDeclaration() && pojoDsl.isWrapped() || parsingContext.getAllSubTypes().contains(objectType)) {
                    DefaultExtensionBuildingDefinitionProvider.this.parseWith(new ObjectTypeParameterParser(definitionBuilder, objectType, extensionClassLoader, dslSyntaxResolver, parsingContext));
                }
                DefaultExtensionBuildingDefinitionProvider.this.registerSubTypes(objectType, definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext);
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                DefaultExtensionBuildingDefinitionProvider.this.registerTopLevelParameter(arrayType.getType(), definitionBuilder.copy(), extensionClassLoader, dslSyntaxResolver, parsingContext);
            }

            @Override
            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept(this));
            }
        });
    }

    private void registerExportedTypesTopLevelParsers(ExtensionModel extensionModel, ComponentBuildingDefinition.Builder definitionBuilder, ClassLoader extensionClassLoader, DslSyntaxResolver dslSyntaxResolver, ExtensionParsingContext parsingContext) {
        this.registerTopLevelParameters(extensionModel.getTypes().stream(), definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext);
    }

    private void registerSubTypes(ComponentBuildingDefinition.Builder definitionBuilder, ClassLoader extensionClassLoader, DslSyntaxResolver dslSyntaxResolver, ExtensionParsingContext parsingContext) {
        ImmutableList mappedTypes = new ImmutableList.Builder().addAll(parsingContext.getAllSubTypes()).addAll(parsingContext.getAllBaseTypes()).build();
        this.registerTopLevelParameters(mappedTypes.stream(), definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext);
    }

    private void registerTopLevelParameters(Stream<? extends MetadataType> parameters, ComponentBuildingDefinition.Builder definitionBuilder, ClassLoader extensionClassLoader, DslSyntaxResolver dslSyntaxResolver, ExtensionParsingContext parsingContext) {
        parameters.filter(IntrospectionUtils::isInstantiable).forEach(subType -> this.registerTopLevelParameter((MetadataType)subType, definitionBuilder, extensionClassLoader, dslSyntaxResolver, parsingContext));
    }

    private ExtensionParsingContext createParsingContext(ExtensionModel extensionModel) {
        return new ExtensionParsingContext(extensionModel);
    }

    @Override
    public void setExtensionModels(Set<ExtensionModel> extensionModels) {
        this.extensions = extensionModels;
    }
}

