/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.reflect.Type;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.annotation.DataTypeParameters;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class DataTypeDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
        new IdempotentDeclarationWalker(){

            @Override
            protected void onOperation(OperationDeclaration declaration) {
                MuleExtensionUtils.getImplementingMethod(declaration).ifPresent(method -> {
                    DataTypeParameters annotation = method.getAnnotation(DataTypeParameters.class);
                    if (annotation != null) {
                        if (IntrospectionUtils.isVoid(method)) {
                            throw new IllegalModelDefinitionException(String.format("Operation '%s' of extension '%s' is void yet requires the ability to change the content metadata. Mutating the content metadata requires an operation with a return type.", declaration.getName(), declaration.getName()));
                        }
                        declaration.getParameterGroup("General").addParameter(DataTypeDeclarationEnricher.this.newParameter("outputMimeType", "The mime type of the payload that this operation outputs."));
                        declaration.getParameterGroup("General").addParameter(DataTypeDeclarationEnricher.this.newParameter("outputEncoding", "The encoding of the payload that this operation outputs."));
                    }
                });
            }
        }.walk(declaration);
    }

    private ParameterDeclaration newParameter(String name, String description) {
        ParameterDeclaration parameter = new ParameterDeclaration(name);
        parameter.setRequired(false);
        parameter.setExpressionSupport(ExpressionSupport.SUPPORTED);
        parameter.setType(this.typeLoader.load((Type)((Object)String.class)), false);
        parameter.setDescription(description);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        return parameter;
    }
}

