/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.MetadataResolverUtils;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.internal.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.internal.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class MetadataComponentModelValidator
implements ExtensionModelValidator {
    private static final String EMPTY_RESOLVER_NAME = "%s '%s' specifies a metadata resolver [%s] which has an empty %s name";

    @Override
    public void validate(final ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        if (!(extensionModel instanceof ExtensionModel)) {
            return;
        }
        HashBasedTable names = HashBasedTable.create();
        new ExtensionWalker((Table)names){
            final /* synthetic */ Table val$names;
            {
                this.val$names = table;
            }

            @Override
            public void onOperation(HasOperationModels owner, OperationModel model) {
                this.validateComponent(model);
            }

            @Override
            public void onSource(HasSourceModels owner, SourceModel model) {
                this.validateComponent(model);
            }

            private void validateComponent(ComponentModel model) {
                MetadataComponentModelValidator.this.validateMetadataReturnType(extensionModel, model, problemsReporter);
                MetadataResolverFactory resolverFactory = MuleExtensionUtils.getMetadataResolverFactory(model);
                MetadataComponentModelValidator.this.validateMetadataOutputAttributes(model, resolverFactory, problemsReporter);
                MetadataComponentModelValidator.this.validateMetadataKeyId(model, resolverFactory, problemsReporter);
                MetadataComponentModelValidator.this.validateCategoriesInScope(model, resolverFactory, problemsReporter);
                MetadataComponentModelValidator.this.validateResolversName(model, resolverFactory, this.val$names, problemsReporter);
            }
        }.walk(extensionModel);
    }

    private void validateResolversName(ComponentModel model, MetadataResolverFactory resolverFactory, Table<String, String, Class<?>> names, ProblemsReporter problemsReporter) {
        LinkedList<NamedTypeResolver> resolvers = new LinkedList<NamedTypeResolver>();
        resolvers.addAll(this.getAllInputResolvers(model, resolverFactory));
        resolvers.add(resolverFactory.getOutputResolver());
        resolvers.stream().filter(r -> !r.getClass().equals(NullMetadataResolver.class)).forEach(r -> {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)r.getResolverName())) {
                problemsReporter.addError(new Problem(model, String.format(EMPTY_RESOLVER_NAME, NameUtils.getComponentModelTypeName(model), model.getName(), r.getClass().getSimpleName(), "resolver")));
            } else {
                if (names.get((Object)r.getCategoryName(), (Object)r.getResolverName()) != null && names.get((Object)r.getCategoryName(), (Object)r.getResolverName()) != r.getClass()) {
                    problemsReporter.addError(new Problem(model, String.format("%s [%s] specifies metadata resolvers with repeated name [%s] for the same category [%s]. Resolver names should be unique for a given category. Affected resolvers are '%s' and '%s'", NameUtils.getComponentModelTypeName(model), model.getName(), r.getResolverName(), r.getCategoryName(), ((Class)names.get((Object)r.getCategoryName(), (Object)r.getResolverName())).getSimpleName(), r.getClass().getSimpleName())));
                }
                names.put((Object)r.getCategoryName(), (Object)r.getResolverName(), r.getClass());
            }
        });
    }

    private void validateMetadataKeyId(final ComponentModel model, MetadataResolverFactory resolverFactory, final ProblemsReporter problemsReporter) {
        Optional<MetadataKeyIdModelProperty> keyId = model.getModelProperty(MetadataKeyIdModelProperty.class);
        if (keyId.isPresent()) {
            if (resolverFactory.getOutputResolver() instanceof NullMetadataResolver && this.getAllInputResolvers(model, resolverFactory).isEmpty()) {
                problemsReporter.addError(new Problem(model, String.format("Component [%s] defines a MetadataKeyId parameter but neither an Output nor Type resolver that makes use of it was defined", model.getName())));
            }
            keyId.get().getType().accept(new MetadataTypeVisitor(){

                @Override
                public void visitObject(ObjectType objectType) {
                    List parts = model.getAllParameterModels().stream().filter(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).collect(Collectors.toList());
                    List defaultParts = parts.stream().filter(p -> p.getDefaultValue() != null).collect(Collectors.toList());
                    if (!defaultParts.isEmpty() && defaultParts.size() != parts.size()) {
                        problemsReporter.addError(new Problem(model, String.format("[%s] type multilevel key defines [%s] MetadataKeyPart with default values, but the type contains [%s] MetadataKeyParts. All the annotated MetadataKeyParts should have a default value if at least one part has a default value.", JavaTypeUtils.getType(objectType).getSimpleName(), defaultParts.size(), parts.size())));
                    }
                }
            });
        } else if (!(resolverFactory.getKeyResolver() instanceof NullMetadataResolver)) {
            problemsReporter.addError(new Problem(model, String.format("Component [%s] does not define a MetadataKeyId parameter but a type keys resolver of type [%s] was associated to it", model.getName(), resolverFactory.getKeyResolver().getClass().getName())));
        }
    }

    private void validateMetadataOutputAttributes(ComponentModel component, MetadataResolverFactory resolverFactory, ProblemsReporter problemsReporter) {
        if (MetadataTypeUtils.isVoid(component.getOutputAttributes().getType()) && !(resolverFactory.getOutputAttributesResolver() instanceof NullMetadataResolver)) {
            problemsReporter.addError(new Problem(component, String.format("%s '%s' has an attributes metadata resolver defined but it doesn't set any attributes", NameUtils.getComponentModelTypeName(component), component.getName())));
        }
    }

    private void validateMetadataReturnType(final ExtensionModel extensionModel, final ComponentModel component, final ProblemsReporter problemsReporter) {
        if (MuleExtensionUtils.getMetadataResolverFactory(component).getOutputResolver() instanceof NullMetadataResolver) {
            component.getOutput().getType().accept(new MetadataTypeVisitor(){

                @Override
                public void visitObject(ObjectType objectType) {
                    objectType.getOpenRestriction().ifPresent(t -> MetadataComponentModelValidator.this.failIfTypeIsObject(component, extensionModel, t, problemsReporter));
                    MetadataComponentModelValidator.this.failIfTypeIsObject(component, extensionModel, objectType, problemsReporter);
                }

                @Override
                public void visitArrayType(ArrayType arrayType) {
                    arrayType.getType().accept(this);
                }
            });
        }
    }

    private void validateCategoriesInScope(ComponentModel componentModel, MetadataResolverFactory metadataResolverFactory, ProblemsReporter problemsReporter) {
        this.validateCategoryNames(componentModel, problemsReporter, MetadataResolverUtils.getAllResolvers(metadataResolverFactory));
    }

    private List<InputTypeResolver<Object>> getAllInputResolvers(ComponentModel componentModel, MetadataResolverFactory resolverFactory) {
        return componentModel.getAllParameterModels().stream().map(NamedObject::getName).map(resolverFactory::getInputResolver).collect(Collectors.toList());
    }

    private void validateCategoryNames(ComponentModel componentModel, ProblemsReporter problemsReporter, List<NamedTypeResolver> resolvers) {
        resolvers.stream().filter(r -> org.mule.runtime.core.api.util.StringUtils.isBlank(r.getCategoryName())).findFirst().ifPresent(r -> problemsReporter.addError(new Problem(componentModel, String.format(EMPTY_RESOLVER_NAME, NameUtils.getComponentModelTypeName(componentModel), componentModel.getName(), r.getClass().getSimpleName(), "category"))));
        Set names = resolvers.stream().filter(r -> !MetadataResolverUtils.isNullResolver(r)).map(NamedTypeResolver::getCategoryName).collect(Collectors.toSet());
        if (names.size() > 1) {
            problemsReporter.addError(new Problem(componentModel, String.format("%s '%s' specifies metadata resolvers that doesn't belong to the same category. The following categories were the ones found [%s]", NameUtils.getComponentModelTypeName(componentModel), componentModel.getName(), StringUtils.join(names, (String)","))));
        }
    }

    private void failIfTypeIsObject(ComponentModel componentModel, ExtensionModel extensionModel, MetadataType type, ProblemsReporter problemsReporter) {
        if (Object.class.equals(JavaTypeUtils.getType(type))) {
            String componentTypeName = NameUtils.getComponentModelTypeName(componentModel);
            problemsReporter.addError(new Problem(extensionModel, String.format("Extension '%s' specifies a/an %s named '%s' with type '%s' as return type. Operations and Sources with return type such as Object or Map (or a collection of any of those) must have defined a not null OutputTypeResolver", extensionModel.getName(), componentTypeName, componentModel.getName(), ExtensionMetadataTypeUtils.getId(type))));
        }
    }
}

