/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Optional;
import javax.inject.Provider;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ImplicitObjectUtils;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.ImplicitConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class DefaultImplicitConnectionProviderFactory<T>
implements ImplicitConnectionProviderFactory {
    private final ExtensionModel extensionModel;
    private final MuleContext muleContext;
    private Provider<ResolverSet> resolverSetProvider;
    private ConnectionManagerAdapter connectionManagerAdapter = null;
    private ConnectionProviderModel connectionProviderModel = null;
    private ResolverSet resolverSet = null;

    public DefaultImplicitConnectionProviderFactory(ExtensionModel extensionModel, ConfigurationModel configurationModel, MuleContext muleContext) {
        this.extensionModel = extensionModel;
        this.muleContext = muleContext;
        this.resolverSetProvider = () -> {
            DefaultImplicitConnectionProviderFactory defaultImplicitConnectionProviderFactory = this;
            synchronized (defaultImplicitConnectionProviderFactory) {
                if (this.resolverSet == null) {
                    this.connectionProviderModel = ExtensionModelUtils.getFirstImplicit(MuleExtensionUtils.getAllConnectionProviders(extensionModel, configurationModel));
                    if (this.connectionProviderModel == null) {
                        throw new IllegalStateException(String.format("Configuration '%s' of extension '%s' does not define a connection provider and none can be created automatically. Please define one.", configurationModel.getName(), extensionModel.getName()));
                    }
                    this.resolverSet = ImplicitObjectUtils.buildImplicitResolverSet(this.connectionProviderModel, muleContext);
                    this.resolverSetProvider = () -> this.resolverSet;
                }
                return this.resolverSet;
            }
        };
    }

    @Override
    public <T> ConnectionProvider<T> createImplicitConnectionProvider(String configName, Event event) {
        ResolverSet resolverSet = (ResolverSet)this.resolverSetProvider.get();
        DefaultConnectionProviderObjectBuilder builder = new DefaultConnectionProviderObjectBuilder(this.connectionProviderModel, resolverSet, this.getConnectionManager(this.muleContext), this.extensionModel, this.muleContext);
        builder.setOwnerConfigName(configName);
        try {
            return (ConnectionProvider)builder.build(ValueResolvingContext.from(event));
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private ConnectionManagerAdapter getConnectionManager(MuleContext muleContext) {
        if (this.connectionManagerAdapter == null) {
            this.connectionManagerAdapter = (ConnectionManagerAdapter)muleContext.getRegistry().get("_muleConnectionManager");
        }
        return this.connectionManagerAdapter;
    }

    @Override
    public boolean isDynamic() {
        return ((ResolverSet)this.resolverSetProvider.get()).isDynamic();
    }

    @Override
    public Optional<ResolverSet> getResolverSet() {
        return Optional.of(this.resolverSetProvider.get());
    }
}

