/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.util;

import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.object.AbstractObjectFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeanLookup
extends AbstractObjectFactory
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private String bean;

    @Override
    public void initialise() throws InitialisationException {
        if (this.bean == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Bean name has not been set."), (Initialisable)this);
        }
        if (this.applicationContext == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("ApplicationContext has not been injected."), (Initialisable)this);
        }
        this.objectClass = this.applicationContext.getBean(this.bean).getClass();
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object getInstance(MuleContext muleContext) throws Exception {
        Object instance = this.applicationContext.getBean(this.bean);
        if (instance instanceof FlowConstructAware) {
            ((FlowConstructAware)instance).setFlowConstruct(this.flowConstruct);
        }
        this.fireInitialisationCallbacks(instance);
        return instance;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
    }

    @Override
    public boolean isSingleton() {
        return this.applicationContext.isSingleton(this.bean);
    }

    @Override
    public boolean isExternallyManagedLifecycle() {
        return true;
    }

    @Override
    public boolean isAutoWireObject() {
        return false;
    }
}

